debug = true;

function print(...)
	toPrint = {...}
	printString = ""
	for k, v in pairs(toPrint) do
		if(type(v)=="table") then
			print("(table) " .. k)
			printTable(v);
		else
			printString = printString .. v
		end
	end
	CPrint(printString);
end

function printG()
	for k,v in pairs(_G) do
		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
			print("[" .. k .. "] type: " .. type(v));
		else
			print("[" .. k .. "]=" .. v);
		end	
	end
end

function printTable(table)
	for k,v in pairs(table) do
		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
			print("[" .. k .. "] type: " .. type(v));
		else
			print("[" .. k .. "]=" .. v);
		end	
	end
end

function dprint(...)
	if debug == true then
		print(...);
	end
end

-- Override error function to get more info before falling out to C#.
oldError = error;

function luaError(...)
	print(...);
	print(debug.traceback());
	print("=====");
	
	  local level = 1
      while true do
        local info = debug.getinfo(level, "Sl")
        if not info then break end
        if info.what == "C" then   -- is a C function?
          print(level, "C function")
        else   -- a Lua function
        	printTable(info);
        --print("=" .. info.source .. ":" .. info.linedefined .. ":" .. " in function " .. info.name);
        --print(debug.traceback());
--        print("Name  : " .. info.name);
        
--          print(string.format("[%s]:%d",
--                              info.short_src, info.currentline))
        end
        print("-----");
        level = level + 1
      end
    print("=====");
    return oldError(...);
end

-- Event started from C# code
function Cevent(name, ...)
	
end

error = luaError;

-- Handler for processing a triggered event.
function processEvent(objectID, name)
	if name == nil then
		error("name cannot be nil");
	end
	if objectID ~= nil then 	
		print("clicked, with ID " .. objectID .. " and name " .. name .. ".");
	else
		print("clicked, with name " .. name .. ".");
	end
	if(event == nil or event[name] == nil) then
		-- No event registered, just return.
		return;
	end
	for k, v in pairs(event[name]) do
		event[name][v]();
	end
end

--error = function(...)
--	print("error called!");
--	for k,v in pairs(_G) do
--		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
--			print("[" .. k .. "] type: " .. type(v));
--		else
--			print("[" .. k .. "]=" .. v);
--		end	
--	end
--	
--	print(debug.traceback());
--	oldError(...);
--end

--printG();

-- Reegisters a method to trigger when "name" event fires.
function registerEvent(name, method)
	if events == nil then events = {} end;
	if events[name] == nil then events[name] = {} end; 
	table.insert(events[name], method);
end


-- No unregistration yet.

print("Begin test.");

--newFrame = createFrame()
--print(CreateFrame());

--newText = CreateText();

--AddChild(newFrame, newText);

--SetText(newText, "SOMETHING!!");

--newImage = CreateImage()

--newPanel = CreatePane();
--setBackground(newPanel, "Qmark.png");

--AddChild(newFrame, newPanel);

--setGridPosition(newFrame, newText, 1, 0);
--setGridPosition(newFrame, newPanel, 0, 0);

oldAddChild = AddChild;

function AddChild(parent, child)
	if type(parent) ~= "number" then
		error("parent should be number, " .. type(parent) .. " instead.");
	end
	
	if type(child) ~= "number" then
		error("child should be number, " .. type(child) .. " instead.");
	end
	
	dprint("Set " .. parent .. " as parent of " .. child .. ".")
	oldAddChild(parent, child);
end

oldGridPosition = setGridPosition

function setGridPosition(index, object, x, y)
	if type(index) ~= "number" then
		error("index should be number, " .. type(index) .. " instead.");
	end
	
	if type(object) ~= "number" then
		error("object should be number, " .. type(object) .. " instead.");
	end
	
	if type(x) ~= "number" then
		error("x should be number, " .. type(x) .. " instead.");
	end
	
	if type(y) ~= "number" then
		error("y should be number, " .. type(y) .. " instead.");
	end
	dprint("Object " .. object .. " at " .. index .. " set to (" .. x .. "," .. ").")
	oldGridPosition(index, object, x, y)
end


-- The CreateFrame function intended to be used by the applications. Returns a Frame object.
function CreateFrame()
	-- New object
	local newFrame = {}
	newFrame.frameIndex = createFrame();

	newFrame.SetParent = function(self, parent)
		AddChild(parent, self.frameIndex);
	end

	newFrame.AddChild = function(self, child)
		if self.frameIndex == nil then
			error("No frame found.");
		end
		
		if child == nil then
			error("No child found.");
		end
		
		AddChild(self.frameIndex, child:getIndex());
	end
	
	newFrame.SetPosition = function(self, object, x, y)
		setGridPosition(self:getIndex(), object:getIndex(), x, y);
	end

	newFrame.getIndex = function(self)
		return self.frameIndex;
	end
	
	return newFrame;
end

function CreatePane(frame)
	local newPane = {}
	newPane.paneIndex = createPane();
	if newPane.paneIndex == nil then
		error("Pane not created!!");
	end
	newPane.frame = frame;
	
	newPane.SetParent = function(self, parent)
		AddChild(parent, self.paneIndex);
	end

	newPane.AddChild = function(self, child)
		
		if self == nil or self:getIndex() == nil then
			error("No frame found.");
		end
		
		if child == nil or child:getIndex() == nil then
			error("No child found.");
		end
				
		AddChild(self:getIndex(), child:getIndex());
		
	end
	
	newPane.SetPosition = function(self, object, x, y)
		setGridPosition(self:getIndex(), object:getIndex(), x, y);
	end
	
	newPane.SetBackground = function(self, file)
		setBackground(self:getIndex(), file);
	end

	newPane.getIndex = function(self)
		return self.paneIndex;
	end
	
	newPane.registerEvent = function(self, name, method)
		registerEvent(name, method);
	end
	
	return newPane;
end

function CreateText()
	local newText = {};
	newText.textIndex = createText();
	
	newText.getIndex = function(self)
		return self.textIndex;
	end
	
	newText.SetText = function(self, text)
		SetText(self:getIndex(), text);
	end
	
	return newText;
end

function CreateArrowThing(frame)
	local newArrow = {}
	newArrow.myPanel = CreatePane(frame);
	newArrow.upPanel = CreatePane(frame);
	newArrow.downPanel = CreatePane(frame);
	
	newArrow.myPanel:AddChild(newArrow.upPanel);	
	newArrow.myPanel:SetPosition(newArrow.upPanel, 0, 0);
	
	newArrow.myPanel:AddChild(newArrow.downPanel);
	newArrow.myPanel:SetPosition(newArrow.downPanel, 0, 1);
	
	newArrow.myPanel.setUp = function(upFunction)
		newArrow.upPanel:registerEvent("OnClick", upFunction);
	end
	
	newArrow.myPanel.setDown = function(downFunction)
		newArrow.upPanel:registerEvent("OnClick", downFunction);
	end
	
	newArrow.upPanel:SetBackground("ArrowUP.png")
	newArrow.downPanel:SetBackground("ArrowDOWN.png")
	return newArrow.myPanel;
end

sampleFrame = CreateFrame();
leftFrame = CreatePane(sampleFrame);

sampleFrame:AddChild(leftFrame);

sampleFrame:SetPosition(leftFrame, 0, 0);

arrowz = CreateArrowThing()
sampleFrame:AddChild(arrowz);
sampleFrame:SetPosition(arrowz, 1, 0);

newText = CreateText();
newText:SetText("SAMPLE!");

leftFrame:AddChild(newText);
leftFrame:SetPosition(newText, 0, 0);

myVariable=0;

arrowz.setUp(function()
	myVariable = myVariable + 1;
	print("myVariable: " .. myVariable);
end)

print("End test.");
