-- Was actually written for another project before working on this one.

print("Loading tagging system");

-- Tagging system - experimental

-- In "for" loops, "i"=index, "v"=value

-- Grab AddOn info, place into its own environment. ----------------------------
--local addonName, addonTable = ...;

if addonTable==nil then
   -- Probably inside the WowLua editor
   addonTable={};
end

--local oldEnv = getfenv();
--addonTable._G = _G;
--setfenv(1,addonTable);

-- Checks tags table for sanity, creates/deletes stuff if necesarry.
function checkTags(self)
	dprint("Checking tags.");
	if self.Tags == nil then
		error("No database to add tags to.");
	end
	
	if self.Tags == nil then
		self.Tags = {}
	end
	
	-- Unintentional source of data corruption found . . .
	for tag, v in pairs(self.Tags) do
		if type(self.Tags[tag]) == "number" then
			local temp = self.Tags[tag];
			self.Tags[tag] = {}
			self.Tags[tag][temp] = temp;
		end
	end
end

-- Tags are in a hierarchy, with the top level being "system" tags.

-- Adds empty tag to tag table
function newTag(self, name)
	checkTags(self);
	self.Tags[name] = {};
end

-- Assigns tag to object - adds to tag table if necessary
function tagObject(self, tag, objectID)
	if self.Items[objectID]==nil then
		error("objectID nil!");
	end
	
	if tag==nil then
		error("tag nil!");
	end

	checkTags(self);

	-- Add object to tag's list of known objects
	if type(tag)=="string" or type(tag)=="number" then
		if self.Tags[tag] == nil then self.Tags[tag]={} end
		self.Tags[tag][objectID] = objectID;
	else
		error("Tags cannot be of type " .. type(tag) .. "!");
	end
	
	if type(objectID)~="string" and type(objectID)~="number" then
		error("objectID cannot be of type " .. type(objectID) .. "!");
	end
	
	--ReagentRestockerDB.Items[objectID].tags = {}

	
	-- Add tag to object
	if type(self.Items[objectID].tags) == "nil" then
		self.Items[objectID].tags = {}
	end

	self.Items[objectID].tags[tag]=true;
end

-- Removes tag from object, if the tag exists. Does NOT remove the tag from the tag database.
function untagObject(self, tag, objectID)
	dprint("Trying to remove " .. tag .. " from " .. objectID);
	if objectID == nil then
		error("objectID cannot be nil.");
	end
	
	checkTags(self);
	
	if ReagentRestockerDB.Tags[tag]==nil then
		-- The specified tag doesn't exist.
		dprint("Tag " .. tag .. " doesn't seem to exist.");
		return;
	end
	
	if type(self.Tags[tag][objectID]) ~= "nil" then
		self.Tags[tag][objectID] = nil;
	end
   
	if type(self.Items[objectID].tags[tag]) ~= "nil" then
		self.Items[objectID].tags[tag] = nil;
	end
end

-- Removes tag from tag database - has the effect of removing it from all objects
function removeTag(self, name)
	-- Iterate through objects, removing the tag
	for i, v in pairs(self.Items) do
		if self.Items[i].tags[name] ~= nil then
			self.Items[i].tags[name] = nil;
		end
	end
	
	-- Remove the tag from the tag database
	self.Tags[name] = nil;
	
end

-- Removes all tags from the object.
function removeAllTags(self, object)
	if self.Items[object].tags ~= nil then
		for i, v in pairs(self.Items[object].tags) do
			untagObject(i, object);
		end
	end
end

-- Renames tag, which also renames it on all objects
function renameTag(self, old, new)
	-- Iterate through objects, renaming the tag
	for i, v in pairs(self.Items) do
		if self.Items[i].tags[old] ~= nil then
			self.Items[i].tags[new] = self.Items[i].tags[old];
			self.Items[i].tags[old] = nil;
		end
	end

	-- Rename the tag in the tag database
	ReagentRestockerDB.Tags[new] = ReagentRestockerDB.Tags[old];
	ReagentRestockerDB.Tags[old] = nil;
end

-- Gets tags from the object
function getTags(self, objectID)
	return self.Items[objectID].tags;
end

-- Returns true if an object has a particular tag, false otherwise.
function hasTag(self, objectID, tag)
	if self.Items[objectID].tags == nil then
		return false;
	end
	if self.Items[objectID].tags[tag] ~= nil then
		return true;
	else
		return false;
	end
end


-- Recursive print helper function
function rTagPrint(tags)
	for i, v in pairs(tags) do
		if type(v)=="table" then
			return i .. ":\n" .. rTagPrint(v)
		elseif type(v)=="number" or type(v)=="string" then
			return i .. "=" .. v;
		else
			error("Tags cannot be of type " .. type(v) .. "!");
			return "ERROR!";
		end
	end
	return "";
end

-- Prints all known tags
function printTags(self)

	-- No tags table
	if type(self.Tags)=="nil" then
		print("No tags.");
		return;
	end
	
	for i,v in pairs(self.Tags) do
		if type(v)=="table" then
			print(i .. " " .. rTagPrint(v))
		elseif type(v)=="number" or type(v)=="string" then
			print(i .. "=" .. v);
		else
			error("Tags cannot be of type " .. type(v) .. "!");
		end
	end
end


function tagsInit()
	dprint("Init tags.");
	printTags()
end

function createTagDB()
	newDB={}
	newDB.checkTags = checkTags;
	newDB.newTag = newTag;
	newDB.tagObject = tagObject;
	newDB.untagObject = untagObject;
	newDB.removeTag = removeTag;
	newDB.removeAllTags = removeAllTags;
	newDB.renameTag = renameTag;
	newDB.getTags = getTags;
	newDB.hasTag = hasTag;
	newDB.rTagPrint = rTagPrint;
	newDB.printTags = printTags;
	newDB.tagsInit = tagsInit;
	
	newDB.Tags = {};
	newDB.Items = {};
	-- Left over from previous project.
	newDB.ReagentRestockerDB = {}
	
	return newDB;
end

--setfenv(1, oldEnv);
print("Finished loading tagging system");

