local namePanes = {}
namePanes.size = 0;

local selectedContact = -1;

local frame = CreateFrame();
local pane = CreatePane(frame);

local topPane = CreatePane(frame);
local middlePane = CreatePane(frame);
local bottomPane = CreatePane(frame);

pane:SetPosition(topPane,0,0);
pane:SetPosition(middlePane,0,1);
pane:SetPosition(bottomPane,0,2);


frame:AddChild(pane);

pane:AddChild(topPane);
pane:AddChild(middlePane);
pane:AddChild(bottomPane);

newText = CreateTextBox();
newText:SetText("SAMPLE!");

topPane:AddChild(newText);

newText:registerEvent("OnTextChanged", function()
	textString = newText:GetText();
	--newText:SetText(textString .. ".");
end);

addButton = CreateButton(frame);
addButton:SetText("<Add contact>");

--
removeButton = CreateText();
removeButton:SetText("<Remove contact>");

messageButton = CreateText();
messageButton:SetText("<Send message>");

bottomPane:AddChild(addButton);
bottomPane:AddChild(removeButton);
bottomPane:AddChild(messageButton);

bottomPane:SetPosition(addButton,0,0);
bottomPane:SetPosition(removeButton,1,0);
bottomPane:SetPosition(messageButton,2,0);

addButton:registerEvent("OnClick", function()
	addItem(newText:GetText());
	--newText:SetText(newText:GetText() .. "ADD!");
end);

removeButton:registerEvent("OnClick", function() 
	--pane:RemoveChild(removeButton);
	local countReduce = 0
	for count = 1,namePanes.size,1  do
		print(type(namePanes[count]));
		if namePanes[count].isSelected == true then
			pane:RemoveChild(namePanes[count]);
			namePanes[count] = nil;
			countReduce = countReduce + 1;
		end
	end
	reindexContactList()
	namePanes.size = namePanes.size - countReduce; 
end);

function addItem(item)
	local newPane = CreatePane(frame);
	namePanes.size = namePanes.size + 1;
	namePanes[namePanes.size] = newPane;
	middlePane:SetPosition(newPane,0,namePanes.size-1);
	middlePane:AddChild(newPane);
	local newText = CreateTextBox();
	newText:SetText(item);
	newPane:AddChild(newText);
	
	newPane.isSelected = false;
	
	newPane:registerEvent("OnMouseEnter", function() 
		if newPane.isSelected == false then
			newPane:SetBackground("ltblue.png");
		else
			newPane:SetBackground("blue.png");
		end
	end);

	newPane:registerEvent("OnMouseLeave", function() 
		if newPane.isSelected == false then
			newPane:SetBackground("white.png");
--			newPane:SetBackground("white.png");
		else
			newPane:SetBackground("blue.png");
		end
	end);
	
	newPane:registerEvent("OnClick", function() 
		if newPane.isSelected == false then
			newPane.isSelected = true;
			newPane:SetBackground("blue.png");
		else
			newPane:SetBackground("ltblue.png");
			newPane.isSelected = false;
		end
	end);

	newText:registerEvent("OnClick", function() 
		if newPane.isSelected == false then
			newPane.isSelected = true;
			newPane:SetBackground("blue.png");
		else
			newPane:SetBackground("ltblue.png");
			newPane.isSelected = false;
		end
	end);
end

-- Reindexes the contact list after a removal.
function reindexContactList()
	lastCount = 1;
	for count = 1,namePanes.size,1  do
		if namePanes[count] ~= nil then
			middlePane:SetPosition(namePanes[count],0,lastCount);
			namePanes[lastCount]=namePanes[count];
			lastCount = lastCount + 1;
		end
	end
end
