-- Base functions, includes:
-- Communicating with C# and event handling
-- Base UI structures

if errorLoaded ~= true then
	error("error.lua not loaded.");
end

errorLoaded = nil;

local myDebug = true;



function printG()
	for k,v in pairs(_G) do
		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
			print("[" .. k .. "] type: " .. type(v));
		else
			print("[" .. k .. "]=" .. v);
		end	
	end
end

function printTable(table)
	for k,v in pairs(table) do
		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
			print("[" .. k .. "] type: " .. type(v));
		else
			print("[" .. k .. "]=" .. v);
		end	
	end
end

function dprint(...)
	if myDebug == true then
		print(...);
	end
end

-- Print available C# functions.
function printC()
	for k, v in pairs(_CSHARP) do
		print(k);
	end
end

printC();

-- Make C# values only available locally.
local C = _CSHARP;
_CSHARP = nil;

-- Handler for processing a triggered event.
function processEvent(objectID, name)
	if name == nil then
		error("name cannot be nil");
	end
	
	--[[if objectID ~= nil then 	
		dprint("clicked, with ID " .. objectID .. " and name " .. name .. ".");
	else
		dprint("clicked, with name " .. name .. ".");
	end]]--
	if(events == nil or events[objectID] == nil or events[objectID][name] == nil) then
		-- No event registered, just return.
		dprint("No event triggered in object " .. objectID .. ".");
		return;
	else
		dprint("Triggering ID " .. objectID .. " and name " .. name .. ".");
		events[objectID][name]();
	end
	--[[for k, v in pairs(events[objectID][name]) do
		print("Triggering ID " .. objectID .. " and name " .. name .. ".");
		events[objectID][name][v]();
	end]]--
end

--error = function(...)
--	print("error called!");
--	for k,v in pairs(_G) do
--		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
--			print("[" .. k .. "] type: " .. type(v));
--		else
--			print("[" .. k .. "]=" .. v);
--		end	
--	end
--	
--	print(debug.traceback());
--	oldError(...);
--end

--printG();

-- Reegisters a method to trigger for object "ID" when "name" event fires.
function registerEvent(ID, name, method)
	if ID==nil or name==nil or method==nil then
		error("No nil arguments accepted.")
	end
	
	if type(ID) == "table" then
		if type(ID.getIndex) == "function" then
			ID = ID:getIndex();
		else
			error("ID must be a number.");
		end
	end
	if type(ID) ~= "number" then
		error("ID must be a number.");
	end
	
	if events == nil then events = {} end;
	if events[ID] == nil then events[ID] = {} end;
	if events[ID][name] == nil then events[ID][name] = {} end;

	print("Registering " .. ID .. " with name " .. name);
	
	events[ID][name] = method;
end


-- No unregistration yet.

print("Loading Core.");

--newFrame = createFrame()
--print(CreateFrame());

--newText = CreateText();

--AddChild(newFrame, newText);

--SetText(newText, "SOMETHING!!");

--newImage = CreateImage()

--newPanel = CreatePane();
--setBackground(newPanel, "Qmark.png");

--AddChild(newFrame, newPanel);

--setGridPosition(newFrame, newText, 1, 0);
--setGridPosition(newFrame, newPanel, 0, 0);

--------------------------------------------------------------------------------
-- UI Elements
--------------------------------------------------------------------------------

local oldAddChild = C.addChild;

function AddChild(parent, child)
	if type(parent) ~= "number" then
		error("parent should be number, " .. type(parent) .. " instead.");
	end
	
	if type(child) ~= "number" then
		error("child should be number, " .. type(child) .. " instead.");
	end
	
	dprint("Set " .. parent .. " as parent of " .. child .. ".")
	oldAddChild(parent, child);
end

local oldGridPosition = setGridPosition

function setGridPosition(index, object, x, y)
	if type(index) ~= "number" then
		error("index should be number, " .. type(index) .. " instead.");
	end
	
	if type(object) ~= "number" then
		error("object should be number, " .. type(object) .. " instead.");
	end
	
	if type(x) ~= "number" then
		error("x should be number, " .. type(x) .. " instead.");
	end
	
	if type(y) ~= "number" then
		error("y should be number, " .. type(y) .. " instead.");
	end
	dprint("Object " .. object .. " at " .. index .. " set to (" .. x .. "," .. ").")
	oldGridPosition(index, object, x, y)
end


-- The CreateFrame function intended to be used by the applications. Returns a Frame object.
function CreateFrame()
	-- New object
	local newFrame = {}
	newFrame.frameIndex = C.createFrame();

	newFrame.SetParent = function(self, parent)
		AddChild(parent, self.frameIndex);
	end

	newFrame.AddChild = function(self, child)
		if self.frameIndex == nil then
			error("No frame found.");
		end
		
		if child == nil then
			error("No child found.");
		end
		
		AddChild(self.frameIndex, child:getIndex());
	end
	
	newFrame.SetPosition = function(self, x, y, UNSUPPORTED)
		if UNSUPPORTED~=nil then
			error("GRID is unsupported now!")
		end
		C.setPosition(self:getIndex(), x, y);
		
	end

	newFrame.getIndex = function(self)
		return self.frameIndex;
	end
	
	newFrame.setTitle = function(self, text)
		C.setTitle(self.frameIndex, text);
	end
	
	return newFrame;
end

function CreatePane()
	local newPane = {}
	newPane.paneIndex = C.createPane();
	if newPane.paneIndex == nil then
		error("Pane not created!!");
	end
	
	newPane.SetParent = function(self, parent)
		C.addChild(parent, self.paneIndex);
	end

	newPane.AddChild = function(self, child)
		
		if self == nil or self:getIndex() == nil then
			error("No frame found.");
		end
		
		if child == nil or child:getIndex() == nil then
			error("No child found.");
		end
				
		C.addChild(self:getIndex(), child:getIndex());
		
	end
	
	newPane.RemoveChild = function(self, child)
		
		if self == nil or self:getIndex() == nil then
			error("No pane found.");
		end
		
		if child == nil or child:getIndex() == nil then
			error("No child found.");
		end
				
		C.removeChild(self:getIndex(), child:getIndex());
		
	end

	newPane.RemoveAllChildren = function(self)
		for k, v in pairs() do
			self:RemoveChild(v);
		end
	end
	
	newPane.SetPosition = function(self, x, y, UNSUPPORTED)
		if UNSUPPORTED~=nil then
			error("GRID is unsupported now!")
		end
		
		if type(self.paneIndex)~="number" then
			error("Number expected, got "..type(self).." instead.")
		end
		
		if type(x)~="number" then
			error("Number expected, got "..type(self).." instead.")
		end

		if type(y)~="number" then
			error("Number expected, got "..type(self).." instead.")
		end

		C.setPosition(self.paneIndex, x, y);
	end

	newPane.SetSize = function(self, x, y)
		C.setSize(self.paneIndex, x, y);
	end
	
	newPane.SetBackground = function(self, file)
		C.setBackground(self:getIndex(), file);
	end

	newPane.SetBorderedBackground = function(self, file, width, height)
		C.setBorderedBackground(self:getIndex(), file, width, height);
	end

	newPane.getIndex = function(self)
		if self == nil then
			error("self can't be nil!");
		end
		return self.paneIndex;
	end
	
	newPane.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end
	
	newPane.setPosition = function(self, x, y)
		C.setPosition(self.paneIndex, x, y);
	end
	
	return newPane;
end

function CreateText()
	local newText = {};
	newText.textIndex = C.createText();
	
	newText.getIndex = function(self)
		return self.textIndex;
	end
	
	newText.SetText = function(self, text)
		C.setText(self:getIndex(), text);
	end
	
	newText.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end
	
	newText.setHAlign = function(self, text)
		C.setHAlign(self:getIndex(), text);
	end
	
	newText.setVAlign = function(self, text)
		C.setVAlign(self:getIndex(), text);
	end
	
	newText.setBackground = function(self, path)
		C.setBackground(self.textIndex, path);
	end

	return newText;
end

function CreateTextBox()
	local newEditBox = {};
	newEditBox.index = C.createEditBox();
	
	newEditBox.getIndex = function(self)
		return self.index;
	end
	
	newEditBox.SetText = function(self, text)
		C.setText(self:getIndex(), text);
	end
	
	newEditBox.GetText = function(self)
		return C.getText(self:getIndex());
	end
	
	newEditBox.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end
	
	newEditBox.SetBackground = function(self, file)
		C.setBackground(self:getIndex(), file);
	end
	
	newEditBox.setHAlign = function(self, text)
		C.setHAlign(self:getIndex(), text);
	end
	
	newEditBox.setVAlign = function(self, text)
		C.setVAlign(self:getIndex(), text);
	end

	return newEditBox;
	
end

-- Set up regions as Panes.
Region={}
print(C.Region);
for k,v in pairs(C.Region) do
	local newPane = {}
	newPane.paneIndex = v;
	Region[k]=newPane;
	if newPane.paneIndex == nil then
		error("Pane not created!!");
	end
	
	newPane.SetParent = function(self, parent)
		C.addChild(parent, self.paneIndex);
	end

	newPane.AddChild = function(self, child)
		
		if self == nil or self:getIndex() == nil then
			error("No frame found.");
		end
		
		if child == nil or child:getIndex() == nil then
			error("No child found.");
		end
				
		C.addChild(self:getIndex(), child:getIndex());
		
	end
	
	newPane.RemoveChild = function(self, child)
		
		if self == nil or self:getIndex() == nil then
			error("No pane found.");
		end
		
		if child == nil or child:getIndex() == nil then
			error("No child found.");
		end
				
		C.removeChild(self:getIndex(), child:getIndex());
		
	end

	newPane.RemoveAllChildren = function(self)
		for k, v in pairs() do
			self:RemoveChild(v);
		end
	end
	
	newPane.SetPosition = function(self, x, y, UNSUPPORTED)
		if UNSUPPORTED~=nil then
			error("GRID is unsupported now!")
		end
		
		if type(self.paneIndex)~="number" then
			error("Number expected, got "..type(self).." instead.")
		end
		
		if type(x)~="number" then
			error("Number expected, got "..type(self).." instead.")
		end

		if type(y)~="number" then
			error("Number expected, got "..type(self).." instead.")
		end

		C.setPosition(self.paneIndex, x, y);
	end

	newPane.SetSize = function(self, x, y)
		C.setSize(self.paneIndex, x, y);
	end
	
	newPane.SetBackground = function(self, file)
		C.setBackground(self:getIndex(), file);
	end

	newPane.getIndex = function(self)
		if self == nil then
			error("self can't be nil!");
		end
		return self.paneIndex;
	end
	
	newPane.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end
	
	newPane.setPosition = function(self, x, y)
		C.setPosition(self.paneIndex, x, y);
	end
	
	--return newPane;

end
Region.primary = C.Region.primary;

print("Core loaded.");
