-- Base functions, includes:
-- Communicating with C# and event handling
-- print and error overrides
-- Base UI structures

myDebug = true;

function print(...)
	toPrint = {...}
	printString = ""
	for k, v in pairs(toPrint) do
		if(type(v)=="table") then
			print("(table) " .. k)
			printTable(v);
		elseif type(v)=="boolean" then
			if v then
				printString = printString .. "true"
			else
				printString = printString .. "false"
			end
		else
			printString = printString .. v
		end
	end
	CPrint(printString);
end

function printG()
	for k,v in pairs(_G) do
		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
			print("[" .. k .. "] type: " .. type(v));
		else
			print("[" .. k .. "]=" .. v);
		end	
	end
end

function printTable(table)
	for k,v in pairs(table) do
		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
			print("[" .. k .. "] type: " .. type(v));
		else
			print("[" .. k .. "]=" .. v);
		end	
	end
end

function dprint(...)
	if myDebug == true then
		print(...);
	end
end

-- Override error function to get more info before falling out to C#.
oldError = error;

function luaError(...)
	print("=====");
	print(...);
	print(debug.traceback());
	print("=====");
	
	  local level = 1
      while true do
        local info = debug.getinfo(level, "Sl")
        if not info then break end
        if info.what == "C" then   -- is a C function?
          print(level, "C function")
        else   -- a Lua function
        	printTable(info);
        --print("=" .. info.source .. ":" .. info.linedefined .. ":" .. " in function " .. info.name);
        --print(debug.traceback());
--        print("Name  : " .. info.name);
        
--          print(string.format("[%s]:%d",
--                              info.short_src, info.currentline))
        end
        print("-----");
        level = level + 1
      end
    print("=====");
    return oldError(...);
end

error = luaError;

-- Handler for processing a triggered event.
function processEvent(objectID, name)
	if name == nil then
		error("name cannot be nil");
	end
	
	--[[if objectID ~= nil then 	
		dprint("clicked, with ID " .. objectID .. " and name " .. name .. ".");
	else
		dprint("clicked, with name " .. name .. ".");
	end]]--
	if(events == nil or events[objectID] == nil or events[objectID][name] == nil) then
		-- No event registered, just return.
		dprint("No event triggered in object " .. objectID .. ".");
		return;
	else
		dprint("Triggering ID " .. objectID .. " and name " .. name .. ".");
		events[objectID][name]();
	end
	--[[for k, v in pairs(events[objectID][name]) do
		print("Triggering ID " .. objectID .. " and name " .. name .. ".");
		events[objectID][name][v]();
	end]]--
end

--error = function(...)
--	print("error called!");
--	for k,v in pairs(_G) do
--		if(type(v) == "table" or type(v) == "function" or type(v) == "userdata") then
--			print("[" .. k .. "] type: " .. type(v));
--		else
--			print("[" .. k .. "]=" .. v);
--		end	
--	end
--	
--	print(debug.traceback());
--	oldError(...);
--end

--printG();

-- Reegisters a method to trigger for object "ID" when "name" event fires.
function registerEvent(ID, name, method)
	if ID==nil or name==nil or method==nil then
		error("No nil arguments accepted.")
	end
	
	if type(ID) == "table" then
		if type(ID.getIndex) == "function" then
			ID = ID:getIndex();
		else
			error("ID must be a number.");
		end
	end
	if type(ID) ~= "number" then
		error("ID must be a number.");
	end
	
	if events == nil then events = {} end;
	if events[ID] == nil then events[ID] = {} end;
	if events[ID][name] == nil then events[ID][name] = {} end;

	print("Registering " .. ID .. " with name " .. name);
	
	events[ID][name] = method;
end


-- No unregistration yet.

print("Loading Core.");

--newFrame = createFrame()
--print(CreateFrame());

--newText = CreateText();

--AddChild(newFrame, newText);

--SetText(newText, "SOMETHING!!");

--newImage = CreateImage()

--newPanel = CreatePane();
--setBackground(newPanel, "Qmark.png");

--AddChild(newFrame, newPanel);

--setGridPosition(newFrame, newText, 1, 0);
--setGridPosition(newFrame, newPanel, 0, 0);

oldAddChild = AddChild;

function AddChild(parent, child)
	if type(parent) ~= "number" then
		error("parent should be number, " .. type(parent) .. " instead.");
	end
	
	if type(child) ~= "number" then
		error("child should be number, " .. type(child) .. " instead.");
	end
	
	dprint("Set " .. parent .. " as parent of " .. child .. ".")
	oldAddChild(parent, child);
end

oldGridPosition = setGridPosition

function setGridPosition(index, object, x, y)
	if type(index) ~= "number" then
		error("index should be number, " .. type(index) .. " instead.");
	end
	
	if type(object) ~= "number" then
		error("object should be number, " .. type(object) .. " instead.");
	end
	
	if type(x) ~= "number" then
		error("x should be number, " .. type(x) .. " instead.");
	end
	
	if type(y) ~= "number" then
		error("y should be number, " .. type(y) .. " instead.");
	end
	dprint("Object " .. object .. " at " .. index .. " set to (" .. x .. "," .. ").")
	oldGridPosition(index, object, x, y)
end


-- The CreateFrame function intended to be used by the applications. Returns a Frame object.
function CreateFrame()
	-- New object
	local newFrame = {}
	newFrame.frameIndex = createFrame();

	newFrame.SetParent = function(self, parent)
		AddChild(parent, self.frameIndex);
	end

	newFrame.AddChild = function(self, child)
		if self.frameIndex == nil then
			error("No frame found.");
		end
		
		if child == nil then
			error("No child found.");
		end
		
		AddChild(self.frameIndex, child:getIndex());
	end
	
	newFrame.SetPosition = function(self, object, x, y)
		setGridPosition(self:getIndex(), object:getIndex(), x, y);
	end

	newFrame.getIndex = function(self)
		return self.frameIndex;
	end
	
	return newFrame;
end

function CreatePane(frame)
	local newPane = {}
	newPane.paneIndex = createPane();
	if newPane.paneIndex == nil then
		error("Pane not created!!");
	end
	newPane.frame = frame;
	
	newPane.SetParent = function(self, parent)
		AddChild(parent, self.paneIndex);
	end

	newPane.AddChild = function(self, child)
		
		if self == nil or self:getIndex() == nil then
			error("No frame found.");
		end
		
		if child == nil or child:getIndex() == nil then
			error("No child found.");
		end
				
		AddChild(self:getIndex(), child:getIndex());
		
	end
	
	newPane.RemoveChild = function(self, child)
		
		if self == nil or self:getIndex() == nil then
			error("No pane found.");
		end
		
		if child == nil or child:getIndex() == nil then
			error("No child found.");
		end
				
		RemoveChild(self:getIndex(), child:getIndex());
		
	end

	newPane.RemoveAllChildren = function(self)
		for k, v in pairs() do
			self.RemoveChild();
		end
	end
	
	newPane.SetPosition = function(self, object, x, y)
		setGridPosition(self:getIndex(), object:getIndex(), x, y);
	end
	
	newPane.SetBackground = function(self, file)
		setBackground(self:getIndex(), file);
	end

	newPane.getIndex = function(self)
		if self == nil then
			error("self can't be nil!");
		end
		return self.paneIndex;
	end
	
	newPane.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end
	
	return newPane;
end

function CreateText()
	local newText = {};
	newText.textIndex = createText();
	
	newText.getIndex = function(self)
		return self.textIndex;
	end
	
	newText.SetText = function(self, text)
		SetText(self:getIndex(), text);
	end
	
	newText.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end

	return newText;
end

function CreateTextBox()
	local newEditBox = {};
	newEditBox.index = createEditBox();
	
	newEditBox.getIndex = function(self)
		return self.index;
	end
	
	newEditBox.SetText = function(self, text)
		SetText(self:getIndex(), text);
	end
	
	newEditBox.GetText = function(self)
		return GetText(self:getIndex());
	end
	
	newEditBox.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end
	
	newEditBox.SetBackground = function(self, file)
		setBackground(self:getIndex(), file);
	end
	
	return newEditBox;
	
end

print("Core loaded.");
