-- Compound UI elements.

print("Loading UI elements");

function CreateArrowThing(frame)
	local newArrow = {}
	newArrow.myPanel = CreatePane(frame);
	newArrow.upPanel = CreatePane(frame);
	newArrow.downPanel = CreatePane(frame);
	
	newArrow.myPanel:AddChild(newArrow.upPanel);	
	newArrow.myPanel:SetPosition(newArrow.upPanel, 0, 0);
	
	newArrow.myPanel:AddChild(newArrow.downPanel);
	newArrow.myPanel:SetPosition(newArrow.downPanel, 0, 1);
	
	newArrow.myPanel.setUp = function(upFunction)
		newArrow.upPanel:registerEvent("OnClick", upFunction);
	end
	
	newArrow.myPanel.setDown = function(downFunction)
		newArrow.downPanel:registerEvent("OnClick", downFunction);
	end
	
	newArrow.upPanel:SetBackground("ArrowUP.png")
	newArrow.downPanel:SetBackground("ArrowDOWN.png")
	return newArrow.myPanel;
end

function CreateButton(frame)
	local newButton = {}
	newButton.text = CreateText();
	
	-- We need to do a few things to it.
	local text = newButton.text;
	newButton.getIndex = function(self)
		return self.textIndex;
	end
	
	newButton.SetText = function(self, text)
		SetText(self:getIndex(), text);
	end
	
	newButton.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end

	return newButton;
end

print("Finished loading UI elements");


