-- Compound UI elements.

print("Loading UI elements");

-- Make absolutely sure C# functions are not available directly anymore. 
if type(C)~="nil" or type(_CSHARP)~="nil" then
	error("C# environments not cleared properly. Terminating.");
end

function setAllVisible(self, isVisible)
	self:setVisible(isVisible);
	if self.children ~= nil then
		for k,v in pairs(self.children) do
			if v ~= nil then
				setAllVisible(v, isVisible);
			end
		end
	end
end

function CreateListBox2(frame)
	local newArrow = {}
	newArrow.myPanel = CreatePane(frame);
	newArrow.upPanel = CreatePane(frame);
	newArrow.downPanel = CreatePane(frame);
	
	newArrow.myPanel:AddChild(newArrow.upPanel);	
--	newArrow.myPanel:SetPosition(newArrow.upPanel, 0, 0);
	
	newArrow.myPanel:AddChild(newArrow.downPanel);
--	newArrow.myPanel:SetPosition(newArrow.downPanel, 0, 1);
	
	newArrow.myPanel.setUp = function(upFunction)
		newArrow.upPanel:registerEvent("OnClick", upFunction);
	end
	
	newArrow.myPanel.setDown = function(downFunction)
		newArrow.downPanel:registerEvent("OnClick", downFunction);
	end
	
	newArrow.upPanel:SetBackground("ArrowUP.png")
	newArrow.downPanel:SetBackground("ArrowDOWN.png")
	return newArrow.myPanel;
end

function CreateButton(frame)
	local newButton = {}
	local newText = CreateText(frame);
	
	-- Map text functions to button.
	
	for k, v in pairs(newText) do
		if type(v)=="function" then
			newButton[k] = newText[k];
		end
	end
	
	newButton.textIndex = newText:getIndex();
	
	newButton.getIndex = function(self)
		return self.textIndex;
	end
	
	newButton:setHAlign("center");
	newButton:setVAlign("center");
	newButton:setBorderedBackground("border3.png", 8, 8);
	
	-- We need to do a few things to it.
	local text = newButton.text;
	newButton.getIndex = function(self)
		return self.textIndex;
	end
	
	
	newButton.registerEvent = function(self, name, method)
		registerEvent(self, name, method);
	end

	return newButton;
end

-- Creates a scrollable list.
function CreateListBox(paneList, parent, numPanes)

	-- The class it returns.
	local listBox = {}

	-- Holds the list of panes to scroll
	listBox.list = {}
	
	-- List of panes that can be scrolled
	listBox.panes = paneList;
	
	-- Current scroll position of the list.
	listBox.position = 0;
	
	function listBox.setListPosition(pos)
		listBox.position = pos;
	end
	
	-- Margins and padding.
	listBox.border = 6;
	listBox.spacing = 4;
	listBox.scrollSize = 27;

	-- defaults
	listBox.x = 0;
	listBox.y = 0;
	listBox.width = 100;
	listBox.height = 100;
	
	listBox.cellW = 0;
	listBox.cellH = 0;
	listBox.numPanes = numPanes;
	
	-- Primary outer pane.
	primaryPane = CreatePane(parent);
	primaryPane:SetBorderedBackground("border3.png", 8, 8);
	--primaryPane:SetPosition(x,y);
	--primaryPane:SetSize(width,height);
	
	-- Create scroll bar
	upButton = CreatePane(primaryPane);
	downButton = CreatePane(primaryPane);
	bar = CreatePane(primaryPane);
	slider = CreatePane(primaryPane);
	upButton:SetBackground("ScrollUp.png");
	downButton:SetBackground("ScrollDown.png");
	bar:SetBackground("ScrollBar.png");
	
	function listBox.setPosition(self, x, y)
		primaryPane:SetPosition(x, y);
		listBox.x = x;
		listBox.y = y;
	end	
	
	function listBox.setSize(self, width, height)
		primaryPane:SetSize(width, height);
		self.width = width;
		self.height = height;
		local spacing = self.spacing;
		local border = self.border;
		local scrollSize = self.scrollSize;
		local numPanes = self.numPanes;
		local list = self.list;
		local CHeight;

		-- Cell height (w/out spacing) - calculated on paper for correctness.
		CHeight = (height-(numPanes-1)*spacing-2*border)/numPanes;
		
		-- inner panes
		for count=0,numPanes-1 do
			list[count+1] = CreatePane(primaryPane);
			list[count+1]:SetBorderedBackground("border3.png", 8, 8);
			list[count+1]:SetPosition(border,border+(CHeight+spacing)*count);
			list[count+1]:SetSize(width-border*3-scrollSize,CHeight);
		end

		-- Position scroll bar.
		upButton:SetSize(27,10);
		upButton:SetPosition(width-border-scrollSize, border);
		
		downButton:SetSize(27,10);
		downButton:SetPosition(width-border-scrollSize, height-10-border);

		bar:SetSize(27,height-spacing-scrollSize-10);
		bar:SetPosition(width-border-scrollSize, border+spacing+10);
		
		self.cellW = width-border*3-scrollSize;
		self.cellH = CHeight
	end
	
	function listBox.GetCellWidth(self)
		return self.cellW;
	end
	
	function listBox.GetCellHeight(self)
		return self.cellH;
	end
	
	function listBox.Update(self)
		pos = 1;
		for k, v in pairs(self.panes) do
			if pos >= self.position and pos <= self.numPanes - self.position then
				if v ~= nil then
					v:SetParent(self.list[pos - self.position]:getIndex());
					setAllVisible(v, true);
				end
				pos = pos + 1;
			else
				if v ~= nil then
					setAllVisible(v, false);
				end
			end
		end
	end
	
	function listBox.SetList(self, list)
		self.panes = list;
		self:Update();
	end
	
	upButton:registerEvent("OnClick", function(self)
		if pos > 0 then
			pos = pos - 1;
			self:Update();
		end
	end)
	
	downButton:registerEvent("OnClick", function(self)
		--if pos <  self.numPanes then
			pos = pos + 1;
			print(self);
			self:Update();
		--end
	end)

	-- Set defaults
	listBox:setPosition(0, 0)
	listBox:setSize(100, 100)

	return listBox;
end

print("Finished loading UI elements");


