﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using LuaInterface;
using System.Collections;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace AddonsForLife
{
    // This class is in charge of initializing widgets.
    class Widgets
    {
        // List of objects on screen.
        private ArrayList objectList = new ArrayList();
        Lua myLua = null;
        private Core core = null;
        //Grid content;

        LuaEventHandler luaEvents = new LuaEventHandler();

        public void CPrint(String mystring)
        {
            core.printString(mystring);
            //textBlock1.Text = textBuffer;
            //Console.WriteLine(mystring);
        }

        void onClick(object sender, RoutedEventArgs e)
        {
            Console.WriteLine(sender.ToString());
            Console.WriteLine(e.ToString());
            try
            {
                core.doString("processEvent(nil, \"OnClick\");");
            }
            catch (Exception ex)
            {

                //                LuaDebug debug;
                //                myLua.GetStack(1, debug);
                //myLua.DoString("luaError();");
                //myLua.DoString("error();");

                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + "raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);

            }
        }

        public int createFrame()
        {
            Window newWindow = new Window();
            


            //newWindow.AddHandler(Window.MouseUpEvent, new RoutedEventHandler(onClick));

            Frame newFrame = new Frame(newWindow, core);

            newWindow.Show();

            int index = objectList.Add(newFrame);
            newFrame.setID(index);
            return index;
        }

        public int createText()
        {
            Label label = new Label();
            Text newText = new Text(core, label);
            int index = objectList.Add(newText);
            newText.setID(index);
            return index;
        }

        public int CreateImage()
        {
            Image newImage = new Image();
            return objectList.Add(newImage);
        }

        public int createPane()
        {
            Pane newPane = new Pane(core);
            int index = objectList.Add(newPane);
            newPane.setID(index);
            return index;
        }

        public int createEditBox()
        {
            EditBox newEditBox = new EditBox(core);
            int index = objectList.Add(newEditBox);
            newEditBox.setID(index);
            return index;
        }

        // Lua called function. Sets child as the child of window.
        public void AddChild(int window, int child)
        {
            try
            {
                if (objectList[window] is Frame)
                {
                    //                    Window newWindow = ((Frame)(objectList[window])).getWindow();
                    Frame newWindow = (Frame)(objectList[window]);
                    newWindow.addChild(objectList[child]);
                    //                    if (newWindow.Content is Grid)
                    //                    {
                    //                        content = (Grid)(newWindow.Content);
                    //if (objectList[child] is Text)
                    //{
                    //    content.Children.Add(((Text)objectList[child]).getLabel());
                    //}
                    //else if (objectList[child] is Image)
                    //{
                    //    content.Children.Add(((Image)objectList[child]).getRectangle());
                    //}
                    //else if (objectList[child] is Pane)
                    //{
                    //    content.Children.Add(((Pane)objectList[child]).getPanel());
                    //}
                    //else if (objectList[child] is UIElement)
                    //{
                    //    content.Children.Add(((UIElement)objectList[child]));
                    //}
                    //else
                    //{
                    //    //core.luaError("UIElement expected. Got " + objectList[child].GetType().ToString() + " instead.");
                    //    //Console.WriteLine("ERROR: " + message);
                    //    throw new Exception("UIElement expected. Got " + objectList[child].GetType().ToString() + " instead.");
                    //}
                    //                    }
                    //                    else
                    //                    {
                    //                        core.luaError("Grid expected. Got " + newWindow.Content.GetType().ToString() + " instead.");
                    //                    }
                }
                else if (objectList[window] is Pane)
                {
                    Pane newPane = (Pane)objectList[window];
                    newPane.addChild(objectList[child]);
                } else
                {
                    //core.luaError("Frame expected. Got " + objectList[window].GetType().ToString() + " instead.");
                    throw new Exception("Frame expected. Got " + objectList[window].GetType().ToString() + " instead.");
                }   
            }
            catch (Exception e)
            {
                core.printString(e.ToString());
                core.printString(e.Message);
                core.printString(e.StackTrace);
            }
        }

        public void RemoveChild(int window, int child)
        {
            if (objectList[window] is Pane)
            {
                ((Pane)objectList[window]).removeChild(objectList[child]);
            }
            else
            {
                //core.luaError("Frame expected. Got " + objectList[window].GetType().ToString() + " instead.");
                throw new Exception("Pane expected. Got " + objectList[window].GetType().ToString() + " instead.");
            }
        }
        //======================================================
        // C# side function calls for widgets
        //======================================================
        public void setText(int index, String text)
        {
            if (objectList[index] is Text)
            {
                ((Text)objectList[index]).setText(text);
            }
            else if (objectList[index] is EditBox)
            {
                ((EditBox)objectList[index]).setText(text);
            }
            else
            {
                //core.luaError("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
                throw new Exception("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
            }
        }

        public String getText(int index)
        {
            if (objectList[index] is EditBox)
            {
                return ((EditBox)objectList[index]).getText();
            }
            else
            {
                //core.luaError("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
                throw new Exception("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
            }
        }

        // Sets object index at position (column, row) in the Grid.
        public void setGridPosition(int frame, int item,  int column, int row)
        {

            //if ((objectList[index]) is Text)
            //{
            //    Grid.SetRow(((Text)objectList[index]).getLabel(), row);
            //    Grid.SetColumn(((Text)objectList[index]).getLabel(), column);
            //}
            //else if ((objectList[index]) is Pane)
            //{
            //    Grid.SetRow(((Pane)objectList[index]).getPanel(), row);
            //    Grid.SetColumn(((Pane)objectList[index]).getPanel(), row);
            //}
            //else if ((objectList[index]) is UIElement)
            //{
            //    Grid.SetRow(((UIElement)objectList[index]),row);
            //    Grid.SetColumn(((UIElement)objectList[index]), row);
            //} else
            //{
            //    core.luaError("UIElement expected. Got " + objectList[index].GetType().ToString() + " instead.");
            //}
            if ((objectList[frame]) is Pane)
            {
                Pane myPane = ((Pane)objectList[frame]);
                myPane.setGridPosition(objectList[item], column, row);
            } else if ((objectList[frame]) is Frame)
            {
                Frame myFrame = ((Frame)objectList[frame]);
                myFrame.setGridPosition(objectList[item], column, row);
            }
            else
            {
                throw new Exception("Frame expected. Got " + objectList[frame].GetType().ToString() + " instead.");
            }

        }

        public void setBackground(int panel, String fileName)
        {
            if ((objectList[panel]) is Pane)
            {
                ImageBrush myBrush = new ImageBrush();
                myBrush.ImageSource = new BitmapImage(new Uri("D:\\Documents\\Visual Studio 2008\\Projects\\AddonsForLife\\" + fileName, UriKind.Relative));
                myBrush.TileMode = TileMode.Tile;

                ((Pane)(objectList[panel])).setBackground(myBrush);
            }
            else if ((objectList[panel]) is Text)
            {
                ImageBrush myBrush = new ImageBrush();
                myBrush.ImageSource = new BitmapImage(new Uri("D:\\Documents\\Visual Studio 2008\\Projects\\AddonsForLife\\" + fileName, UriKind.Relative));
                myBrush.TileMode = TileMode.Tile;

                ((Text)(objectList[panel])).setBackground(myBrush);
            }
            else
            {
                throw new Exception("Background setting not supported for " + objectList[panel].GetType());
            }
        }

        // Constructor, registers the functions with Lua
        public Widgets(Lua lua, Core myCore)
        {
            myLua = lua;
            core = myCore;
            myLua.RegisterFunction("createText", this, this.GetType().GetMethod("createText"));
            myLua.RegisterFunction("CreateImage", this, this.GetType().GetMethod("CreateImage"));
            myLua.RegisterFunction("createPane", this, this.GetType().GetMethod("createPane"));
            myLua.RegisterFunction("createEditBox", this, this.GetType().GetMethod("createEditBox"));

            myLua.RegisterFunction("CPrint", this, this.GetType().GetMethod("CPrint"));
            myLua.RegisterFunction("createFrame", this, this.GetType().GetMethod("createFrame"));

            myLua.RegisterFunction("AddChild", this, this.GetType().GetMethod("AddChild"));
            myLua.RegisterFunction("RemoveChild", this, this.GetType().GetMethod("RemoveChild"));

            myLua.RegisterFunction("SetText", this, this.GetType().GetMethod("setText"));
            myLua.RegisterFunction("GetText", this, this.GetType().GetMethod("getText"));
            
            myLua.RegisterFunction("setGridPosition", this, this.GetType().GetMethod("setGridPosition"));
            myLua.RegisterFunction("setBackground", this, this.GetType().GetMethod("setBackground"));

            // Register events

            
            
            
        }

    }
}
