﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using LuaInterface;
using System.Collections;
using System.Windows;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Forms;

namespace AddonsForLife
{
    // This class is in charge of initializing widgets.
    class Widgets
    {
        // List of objects on screen.
        private ArrayList<Pane> objectList = new ArrayList<Pane>();

        // Regions cover the screen(s) that a user has.
        private ArrayList<Region> regionList = new ArrayList<Region>();

        Lua myLua = null;
        private Core core = null;
        //Grid content;

        LuaEventHandler luaEvents = new LuaEventHandler();

        private int primaryRegion;

        public void stopAll()
        {
            for (int x = 0; x < objectList.Count; x++)
            {
                Object obj = objectList[x];
                if(obj is Frame)
                {
                    ((Frame)obj).shutDown();
                }
            }
        }

        void onClick(object sender, RoutedEventArgs e)
        {
            //Console.WriteLine(sender.ToString());
            //Console.WriteLine(e.ToString());
            try
            {
                core.doString("processEvent(nil, \"OnClick\");");
            }
            catch (Exception ex)
            {

                //                LuaDebug debug;
                //                myLua.GetStack(1, debug);
                //myLua.DoString("luaError();");
                //myLua.DoString("error();");

                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + "raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);

            }
        }

        public int createFrame()
        {
            Window newWindow = new Window();
            


            //newWindow.AddHandler(Window.MouseUpEvent, new RoutedEventHandler(onClick));

            Frame newFrame = new Frame(newWindow, core);

            newWindow.Show();

            int index = objectList.Add(newFrame);
            newFrame.setID(index);
            return index;
        }

        public int createText(int parent)
        {
            //Label label = new Label();
            Text newText = new Text(core);
            int index = objectList.Add(newText);
            newText.myID = index;
            return index;
        }

        public int createImage()
        {
            Image newImage = new Image(core);
            return objectList.Add(newImage);
        }

        public int createPane(Parentable parent)
        {
            Pane newPane = new Pane(core);
            if(parent != null)
            {
                //newPane
            }
            int index = objectList.Add(newPane);
            newPane.myID = index;
            return index;
        }

        public int createPaneLua(int parent)
        {
            Pane newPane = new Pane(core);
            int index = objectList.Add(newPane);
            newPane.myID = index;
            return index;
        }

        public void closePane(int index)
        {
            objectList[index].close();
        }

        public int createEditBox()
        {
            EditBox newEditBox = new EditBox(core);
            int index = objectList.Add(newEditBox);
            newEditBox.myID = index;
            return index;
        }

        // Lua called function. Sets child as the child of window.
        public void addChild(int window, int child)
        {
            try
            {
                if (objectList[window] is Frame)
                {
                    //                    Window newWindow = ((Frame)(objectList[window])).getWindow();
                    Frame newWindow = (Frame)(objectList[window]);
                    newWindow.addChild(objectList[child]);
                    //                    if (newWindow.Content is Grid)
                    //                    {
                    //                        content = (Grid)(newWindow.Content);
                    //if (objectList[child] is Text)
                    //{
                    //    content.Children.Add(((Text)objectList[child]).getLabel());
                    //}
                    //else if (objectList[child] is Image)
                    //{
                    //    content.Children.Add(((Image)objectList[child]).getRectangle());
                    //}
                    //else if (objectList[child] is Pane)
                    //{
                    //    content.Children.Add(((Pane)objectList[child]).getPanel());
                    //}
                    //else if (objectList[child] is UIElement)
                    //{
                    //    content.Children.Add(((UIElement)objectList[child]));
                    //}
                    //else
                    //{
                    //    //core.luaError("UIElement expected. Got " + objectList[child].GetType().ToString() + " instead.");
                    //    //Console.WriteLine("ERROR: " + message);
                    //    throw new Exception("UIElement expected. Got " + objectList[child].GetType().ToString() + " instead.");
                    //}
                    //                    }
                    //                    else
                    //                    {
                    //                        core.luaError("Grid expected. Got " + newWindow.Content.GetType().ToString() + " instead.");
                    //                    }
                }
                else if (objectList[window] is Pane)
                {
                    Pane newPane = (Pane)objectList[window];
                    newPane.addChild(objectList[child]);
                }
                else if (objectList[window] is Region)
                {
                    Region newPane = (Region)objectList[window];
                    newPane.addChild(objectList[child]);
                }
                else
                {
                    //core.luaError("Frame expected. Got " + objectList[window].GetType().ToString() + " instead.");
                    throw new Exception("Frame expected. Got " + objectList[window].GetType().ToString() + " instead.");
                }   
            }
            catch (Exception e)
            {
                core.printString(e.ToString());
                core.printString(e.Message);
                core.printString(e.StackTrace);
            }
        }

        public void removeChild(int window, int child)
        {
            if (objectList[window] is Pane)
            {
                ((Pane)objectList[window]).removeChild(objectList[child]);
            }
            else
            {
                //core.luaError("Frame expected. Got " + objectList[window].GetType().ToString() + " instead.");
                throw new Exception("Pane expected. Got " + objectList[window].GetType().ToString() + " instead.");
            }
        }
        //======================================================
        // C# side function calls for widgets
        //======================================================
        public void setText(int index, String text)
        {
            if (objectList[index] is Text)
            {
                ((Text)objectList[index]).setText(text);
            }
            else if (objectList[index] is EditBox)
            {
                ((EditBox)objectList[index]).setText(text);
            }
            else
            {
                //core.luaError("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
                throw new Exception("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
            }
        }

        public String getText(int index)
        {
            if (objectList[index] is EditBox)
            {
                return ((EditBox)objectList[index]).getText();
            }
            else
            {
                //core.luaError("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
                throw new Exception("Text expected. Got " + objectList[index].GetType().ToString() + " instead.");
            }
        }

        public void setBorderedBackground(int panel, String fileName, int width, int height)
        {
            if (fileName == null || fileName == "")
            {
                throw new Exception("File name cannot be empty.");
            }

            //Console.WriteLine(core.rootFolder + fileName);
            try
            {
                if ((objectList[panel]) is Pane)
                {
                    //                ((Pane)(objectList[panel])).setBackground(new BorderDraw(new Uri("D:\\Documents\\Visual Studio 2008\\Projects\\AddonsForLife\\" + fileName, UriKind.Relative), width, height).getAsBrush());
                    ((Pane)(objectList[panel])).setBorderedBackground(new Uri(core.rootFolder + fileName), width, height);
                }
                else if ((objectList[panel]) is Text)
                {
                    ((Text)(objectList[panel])).setBorderedBackground(new Uri(core.rootFolder + fileName), width, height);
                }
                else
                {
                    throw new Exception("Bordered Background setting not supported for " + objectList[panel].GetType());
                }
            }
            catch (System.IO.DirectoryNotFoundException)
            {
                throw new Exception(core.rootFolder + fileName + "not found!");
            }
        }

        public void setBackground(int panel, String fileName)
        {
            if (fileName == null || fileName == "")
            {
                throw new Exception("File name cannot be empty.");
            }

            //Console.WriteLine(core.rootFolder + fileName);

            if ((objectList[panel]) is Pane)
            {
                ImageBrush myBrush = new ImageBrush();
                myBrush.ImageSource = new BitmapImage(new Uri(core.rootFolder + fileName, UriKind.Relative));
                myBrush.TileMode = TileMode.Tile;

                ((Pane)(objectList[panel])).setBackground(myBrush);
            }
            else if ((objectList[panel]) is Text)
            {
                ImageBrush myBrush = new ImageBrush();
                myBrush.ImageSource = new BitmapImage(new Uri(core.rootFolder + fileName, UriKind.Relative));
                myBrush.TileMode = TileMode.Tile;

                ((Text)(objectList[panel])).setBackground(myBrush);
            }
            else
            {
                throw new Exception("Background setting not supported for " + objectList[panel].GetType());
            }
        }

        public void setTitle(int window, String text)
        {
            if ((objectList[window]) is Frame)
            {
                ((Frame)objectList[window]).setTitle(text);
            }
            else
            {
                throw new Exception("Only windows can have titles.");
            }
        }

        public void setHAlign(int index, string text)
        {
            if ((objectList[index]) is Text)
            {
                ((Text)objectList[index]).setHAlign(text);
            }
            else
            {
                throw new Exception("Only text can have alignment.");
            }
        }

        public void setVAlign(int index, string text)
        {
            if ((objectList[index]) is Text)
            {
                ((Text)objectList[index]).setVAlign(text);
            }
            else
            {
                throw new Exception("Only text can have alignment.");
            }
        }

        public void setPosition(int index, int x, int y)
        {
            if ((objectList[index]) is Pane)
            {
                ((Pane)objectList[index]).x = x;
                ((Pane)objectList[index]).y = y;
            }
            else
            {
                throw new Exception((objectList[index]).GetType() + "cannot have its position set.");
            }
        }

        public void setZIndex(int index, int zIndex)
        {
            if ((objectList[index]) is Pane)
            {
                ((Pane)objectList[index]).ZIndex = zIndex;
            }
            else
            {
                throw new Exception((objectList[index]).GetType() + "cannot have a Z Index.");
            }
        }

        public int getZIndex(int index)
        {
            if ((objectList[index]) is Pane)
            {
                return ((Pane)objectList[index]).ZIndex;
            }
            else
            {
                throw new Exception((objectList[index]).GetType() + "cannot have a Z Index.");
            }
        }

        public void setSize(int index, int width, int height)
        {
            if ((objectList[index]) is Text)
            {
                ((Text)objectList[index]).width = width;
                ((Text)objectList[index]).height = height;
            }
            else if ((objectList[index]) is Pane)
            {
                ((Pane)objectList[index]).width = width;
                ((Pane)objectList[index]).height = height;
            }
            else
            {
                throw new Exception("Only panes can have position.");
            }
        }

        public bool isVisible(int index)
        {
            if ((objectList[index]) is Pane)
            {
                return ((Pane)objectList[index]).visibile;
            }
            else
            {
                throw new Exception("Visibility not implemented for " + (objectList[index]).GetType().ToString());
            }
        }

        public void setVisible(int index, bool visible)
        {
            if ((objectList[index]) is Pane)
            {
                ((Pane)objectList[index]).visibile = visible;
            }
            else
            {
                throw new Exception("Visibility not implemented for " + (objectList[index]).GetType().ToString());
            }
        }

        Timer updateTimer = new Timer();
        void onUpdate(object sender, EventArgs e)
        {
            core.doString("if processEvent ~= nil then processEvent(" + primaryRegion + ", \"OnUpdate\"); end");
            core.doString(@"mouse.X = " + System.Windows.Forms.Control.MousePosition.X +
                        @"; mouse.Y = " + System.Windows.Forms.Control.MousePosition.Y);
            updateTimer.Enabled = true;

        }

        // Constructor, registers the functions with Lua
        public Widgets(Lua lua, Core myCore)
        {
            myLua = lua;
            core = myCore;
            myLua.RegisterFunction("_CSHARP.createText", this, this.GetType().GetMethod("createText"));
            myLua.RegisterFunction("_CSHARP.createImage", this, this.GetType().GetMethod("createImage"));
            myLua.RegisterFunction("_CSHARP.createPane", this, this.GetType().GetMethod("createPaneLua"));
            myLua.RegisterFunction("_CSHARP.createEditBox", this, this.GetType().GetMethod("createEditBox"));

            myLua.RegisterFunction("_CSHARP.closePane", this, this.GetType().GetMethod("closePane"));

            myLua.RegisterFunction("_CSHARP.createFrame", this, this.GetType().GetMethod("createFrame"));

            myLua.RegisterFunction("_CSHARP.addChild", this, this.GetType().GetMethod("addChild"));
            myLua.RegisterFunction("_CSHARP.removeChild", this, this.GetType().GetMethod("removeChild"));

            myLua.RegisterFunction("_CSHARP.setText", this, this.GetType().GetMethod("setText"));
            myLua.RegisterFunction("_CSHARP.getText", this, this.GetType().GetMethod("getText"));
            myLua.RegisterFunction("_CSHARP.setTitle", this, this.GetType().GetMethod("setTitle"));

            myLua.RegisterFunction("_CSHARP.setHAlign", this, this.GetType().GetMethod("setHAlign"));
            myLua.RegisterFunction("_CSHARP.setVAlign", this, this.GetType().GetMethod("setVAlign"));

            myLua.RegisterFunction("_CSHARP.setPosition", this, this.GetType().GetMethod("setPosition"));
            myLua.RegisterFunction("_CSHARP.setSize", this, this.GetType().GetMethod("setSize"));
            myLua.RegisterFunction("_CSHARP.setBackground", this, this.GetType().GetMethod("setBackground"));
            myLua.RegisterFunction("_CSHARP.setBorderedBackground", this, this.GetType().GetMethod("setBorderedBackground"));
            myLua.RegisterFunction("_CSHARP.isVisible", this, this.GetType().GetMethod("isVisible"));
            myLua.RegisterFunction("_CSHARP.setVisible", this, this.GetType().GetMethod("setVisible"));
            myLua.RegisterFunction("_CSHARP.setZIndex", this, this.GetType().GetMethod("setZIndex"));
            myLua.RegisterFunction("_CSHARP.getZIndex", this, this.GetType().GetMethod("getZIndex"));

            //myCanvas.AddHandler(Canvas.MouseMoveEvent, new RoutedEventHandler(onMouseMove));
            //myLua.RegisterFunction("_CSHARP.OnUpdate", this, this.GetType().GetMethod("setVisible"));

            core.doString(@"if mouse==nil then mouse={} end
                        mouse.X = " + System.Windows.Forms.Control.MousePosition.X +
            @"; mouse.Y = " + System.Windows.Forms.Control.MousePosition.Y);
            //CompositionTarget.Rendering += onUpdate;
            updateTimer.Interval = 33;
            updateTimer.Tick += onUpdate;
            updateTimer.Start();

            // Register events

            // Create regions.

            //maxWindow.AllowsTransparency = true;
            //maxWindow.WindowStyle = System.Windows.WindowStyle.None;

            ////SolidColorBrush tBrush = new SolidColorBrush(Color.FromArgb(1, 0, 0, 0));
            //ImageBrush tBrush = new ImageBrush(new BitmapImage(new Uri("D:\\Documents\\Visual Studio 2008\\Projects\\AddonsForLife\\hole.png")));
            //maxWindow.Background = tBrush;
            ////maxWindow.Background = System.Windows.Media.Brushes.Transparent;

            //maxWindow.WindowStartupLocation = WindowStartupLocation.CenterScreen;

            //maxWindow.Width = System.Windows.SystemParameters.PrimaryScreenWidth;
            //maxWindow.Height = System.Windows.SystemParameters.PrimaryScreenHeight;
            //maxWindow.WindowState = System.Windows.WindowState.Maximized;

            //Button closeButton = new Button();
            //closeButton.Content = "x";

            //closeButton.Click += delegate(Object sender, RoutedEventArgs e) { maxWindow.Close(); };

            // Create a region for each screen that a user has.
            //primaryRegion = System.Windows.Forms.Screen.PrimaryScreen;

            core.doString("_CSHARP.Region = {}");
            foreach (var screen in System.Windows.Forms.Screen.AllScreens)
            {
                Region newRegion = new Region(core);

                // Set the attributes for our new region.
                // Theoretically, they are read/write in C#,
                // but in Lua they will be made read-only.
                newRegion.x = screen.Bounds.X;
                newRegion.y = screen.Bounds.Y;
                newRegion.isPrimary = screen.Primary;
                newRegion.width = screen.Bounds.Width;
                newRegion.height = screen.Bounds.Height;
                
                newRegion.regionID = regionList.Add(newRegion);

                // From Lua's point of view, the region list simply points
                // to Panes the user can use.
                newRegion.objectID = objectList.Add(newRegion);

                if (newRegion.isPrimary)
                {
                    core.doString("_CSHARP.Region.primary = " + newRegion.regionID + ";");
                    primaryRegion = newRegion.regionID;
                }

                //if (newRegion.isPrimary)
                //{
                //    Console.WriteLine("Screen " + newRegion.regionID + " ID " + newRegion.objectID + " is primary");
                //}
                //else
                //{
                //    Console.WriteLine("Screen " + newRegion.regionID + " ID " + newRegion.objectID);
                //}
                //Console.WriteLine(newRegion.width + "x" + newRegion.height);
                //Console.WriteLine("X: " + newRegion.x + " Y: " + newRegion.y);
                //Console.WriteLine();

                core.doString("_CSHARP.Region[" + newRegion.regionID + "]=" + newRegion.objectID + ";");

                newRegion.setup();
                // 
            }

            //maxPanel = new Canvas();

            //maxPanel.Width = System.Windows.SystemParameters.PrimaryScreenWidth;
            //maxPanel.Height = System.Windows.SystemParameters.PrimaryScreenHeight;

            //maxPanel.Children.Add(closeButton);

            ////Canvas.SetTop(closeButton, 0);
            ////Console.WriteLine(System.Windows.SystemParameters.PrimaryScreenWidth);
            ////Canvas.SetRight(closeButton, System.Windows.SystemParameters.PrimaryScreenWidth / 2);

            //closeButton.SetValue(Canvas.RightProperty, 0.0);
            //closeButton.SetValue(Canvas.TopProperty, 0.0);

            //maxWindow.Content = maxPanel;

            //maxWindow.Show();

        }

        // Closes all regions.
        public void closeAllRegions()
        {
            foreach(Region r in regionList)
            {
                r.close();
            }
        }

    }
}
