﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows;

namespace AddonsForLife
{
    class Region
    {
        internal int objectID { get; set; }
        internal int regionID { get; set; }
        internal bool isPrimary { get; set; }

        internal int x { get; set; }
        internal int y { get; set; }
        internal int width { get; set; }
        internal int height { get; set; }

        private Core core;
        private Window window = new Window();
        private Pane pane;

        internal Region(Core core)
        {
            this.core = core;
            pane = new Pane(core);
            window.Content = pane.getCanvas();
        }


        internal void addChild(object p)
        {
            pane.addChild(p);
        }

        // Sets up the window and canvas after the attributes are set.
        internal void setup()
        {
            window.AllowsTransparency = true;
            window.WindowStyle = System.Windows.WindowStyle.None;
            window.Background = System.Windows.Media.Brushes.Transparent;
            //window.WindowStartupLocation = WindowStartupLocation.CenterScreen;
            window.Width = width;
            window.Height = height;
            window.Left = x;
            window.Top = y;
            //window.WindowState = System.Windows.WindowState.Maximized;
            
            Button closeButton = new Button();
            closeButton.Content = "x";
            closeButton.Click += delegate(Object sender, RoutedEventArgs e) { window.Close(); };
            closeButton.Width = 32;
            closeButton.Height = 32;

            pane.height = height;
            pane.width = width;

            closeButton.SetValue(Canvas.RightProperty, 0.0);
            closeButton.SetValue(Canvas.TopProperty, 0.0);

            pane.addChild(closeButton);

            window.Show();
        }

        public Pane getPane()
        {
            return pane;
        }

    }
}
