﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows;

namespace AddonsForLife
{
    // Temporary name
    class Pane
    {
        Canvas myCanvas;

        int myID;

        public int height
        {
            get{return (int)myCanvas.Height;}
            set { myCanvas.Height = (double)value; }
        }

        public int width
        {
            get { return (int)myCanvas.Width; }
            set { myCanvas.Width = (double)value; }
        }

        public int x
        {
            get { return (int)myCanvas.GetValue(Canvas.TopProperty); }
            set { myCanvas.SetValue(Canvas.TopProperty, (double)value); }
        }

        public int y
        {
            get { return (int)myCanvas.GetValue(Canvas.LeftProperty); }
            set { myCanvas.SetValue(Canvas.LeftProperty, (double)value); }
        }

        Core core;

        void onClick(object sender, RoutedEventArgs e)
        {
            Console.WriteLine(sender.ToString());
            Console.WriteLine(e.ToString());
            Console.WriteLine("This: " + this.ToString() + "(OnClick)");
            core.doString("processEvent(" + myID.ToString() + ", \"OnClick\");");
        }

        void onMouseEnter(object sender, RoutedEventArgs e)
        {
            //myPanel.Background = Brushes.Aqua;
            Console.WriteLine(sender.ToString());
            Console.WriteLine(e.ToString());
            Console.WriteLine("This: " + this.ToString() + "(OnMouseEnter)");
            core.doString("processEvent(" + myID.ToString() + ", \"OnMouseEnter\");");
        }

        void onMouseLeave(object sender, RoutedEventArgs e)
        {
            //myPanel.Background = Brushes.AliceBlue;
            Console.WriteLine(sender.ToString());
            Console.WriteLine(e.ToString());
            Console.WriteLine("This: " + this.ToString() + "(OnMouseLeave)");
            core.doString("processEvent(" + myID.ToString() + ", \"OnMouseLeave\");");
        }

        public Pane(Core newCore)
        {
            core = newCore;

            myCanvas = new Canvas();
            myCanvas.Background = Brushes.Transparent;
            myCanvas.AddHandler(Canvas.MouseUpEvent, new RoutedEventHandler(onClick));
            myCanvas.AddHandler(Canvas.MouseEnterEvent, new RoutedEventHandler(onMouseEnter));
            myCanvas.AddHandler(Canvas.MouseLeaveEvent, new RoutedEventHandler(onMouseLeave));
        }

        public Canvas getCanvas()
        {
            return myCanvas;
        }

        public void setBackground(Brush background)
        {
            //Console.WriteLine("Background set attempted.");
            //myCanvas.Background = Brushes.Aqua;
            myCanvas.Background = background;
            //myPanel.Background.
        }

        public void setBorderedBackground(Uri image, int width, int height)
        {
            BorderDraw myDraw = new BorderDraw(image, width, height);
            myCanvas.Background = myDraw.getAsBrush();
        }

        public void addChild(object p)
        {
                myCanvas.Children.Add(unwrap(p));
        }

        public void removeChild(object p)
        {
            Console.WriteLine("Attempting to remove " + p.ToString() + " of type " + p.GetType() + ".");
            try
            {
                UIElement child = unwrap(p);
                child.Visibility = Visibility.Hidden;
                myCanvas.Children.Remove(child);
                myCanvas.UpdateLayout();
            }
            catch (Exception e)
            {
                Console.WriteLine("Error: " + e.Message);
            }
            Console.WriteLine("Attempted to remove");
        }

        // Helper method to unwrap objects I've wrapped.
        private UIElement unwrap(object p)
        {
            if (p is Text)
            {
                return ((Text)(p)).getLabel();
            }
            else if (p is Pane)
            {
                return ((Pane)(p)).getCanvas();
            }
            else if ((p) is UIElement)
            {
                return (UIElement)(p);
            }
            else
            {
                throw new Exception("Inappropriate type. Got " + p.GetType().ToString() + " instead.");
            }
        }

        public void setID(int id)
        {
            myID = id;
        }

        internal void SetValue(DependencyProperty dependencyProperty, object value)
        {
            myCanvas.SetValue(dependencyProperty, value);
            //throw new NotImplementedException();
        }
    }
}
