﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows;
using System.Collections;

namespace AddonsForLife
{
    class Pane
    {
        protected Canvas myCanvas;

        // Helper class that braws borders.
        protected BorderDraw myDraw;

        protected Core core;

        public int myID { get; set; }

        private Pane myParent;
        private ArrayList<Pane> myChildren;

        private Rect dragBox;
        private bool beginDrag = false;

        // A stack of drag and drop targets. Top element is always the drag source/target.
        Stack<Pane> dropTargets = new Stack<Pane>();

        public Pane Parent
        {
            get
            {
                return myParent;
            }

            set
            {
                // Remove from current parent, then add to this as new parent.
                if (this != null && this.Parent != null)
                {
                    this.Parent.getCanvas().Children.Remove(unwrap(this));
                    this.Parent.Children.Remove(this);
                }
                myParent = value;
                if (myParent != null)
                {
                    myParent.getCanvas().Children.Add(unwrap(this));
                    myParent.Children.Add(this);
                }
            }
        }

        // Setting children must be done in helper functions.
        public ArrayList<Pane> Children { get { return myChildren; } }

        public bool visibile
        { 
            get
            {
                if (myCanvas.Visibility==System.Windows.Visibility.Visible) { return true; } else { return false; }
            } 
            
            set 
            {
                if (value == true)
                {
                    myCanvas.Visibility = System.Windows.Visibility.Visible;
                }
                else
                {
                    myCanvas.Visibility = System.Windows.Visibility.Hidden;
                }
            } 
        }

        // Hides this and all children.
        protected void hideAll()
        {
            visibile = false;
            foreach (Pane p in Children)
            {
                p.hideAll();
            }
        }

        public int height
        {
            get{return (int)myCanvas.Height;}
            set
            {
                myCanvas.Height = (double)value;

                // Very ugly (but required) hack to pass information to the Brush we are using.
                if (myDraw != null)
                {
                    myDraw.brushHeight = value;
                    myDraw.update();
                    myCanvas.Background = myDraw.getAsBrush();
                }
            }
        }

        public int width
        {
            get { return (int)myCanvas.Width; }
            set
            {
                myCanvas.Width = (double)value;

                // Very ugly (but required) hack to pass information to the Brush we are using.
                if (myDraw != null)
                {
                    myDraw.brushWidth = value;
                    myDraw.update();
                    myCanvas.Background = myDraw.getAsBrush();
                }
            }
        }

        public double x
        {
            get { return (double)myCanvas.GetValue(Canvas.LeftProperty); }
            set { myCanvas.SetValue(Canvas.LeftProperty, (double)value); }
        }

        public double y
        {
            get { return (double)myCanvas.GetValue(Canvas.TopProperty); }
            set { myCanvas.SetValue(Canvas.TopProperty, (double)value); }
        }

        public int ZIndex
        {
            get 
            {
                return Canvas.GetZIndex(myCanvas);
            }
            set 
            {
                //Console.WriteLine("Tried to set zIndex to " + value);
                Canvas.SetZIndex(myCanvas, value);
            }
        }

        void onClick(object sender, RoutedEventArgs e)
        {
            core.doString("processEvent(" + myID.ToString() + ", \"OnClick\");");
        }

        void onDoubleClick(object sender, RoutedEventArgs e)
        {
            core.doString("processEvent(" + myID.ToString() + ", \"OnDoubleClick\");");
        }

        void onMouseEnter(object sender, RoutedEventArgs e)
        {
            dropTargets.Push(this);
            core.doString("processEvent(" + myID.ToString() + ", \"OnMouseEnter\");");
        }

        void onMouseLeave(object sender, RoutedEventArgs e)
        {
            if (dropTargets.Peek() == this)
            {
                dropTargets.Pop();
            }
            else
            {
                throw new Exception("Unexpected stack behavior!");
            }
            core.doString("processEvent(" + myID.ToString() + ", \"OnMouseLeave\");");
        }

        void onMouseDown(object sender, RoutedEventArgs e)
        {
            Size dragSize = new Size(System.Windows.Forms.SystemInformation.DragSize.Width, System.Windows.Forms.SystemInformation.DragSize.Height);
            dragBox = new Rect(new Point(System.Windows.Forms.Control.MousePosition.X, System.Windows.Forms.Control.MousePosition.Y), dragSize);
            beginDrag = true;

            core.doString("processEvent(" + myID.ToString() + ", \"OnMouseDown\");");
        }

        void onMouseUp(object sender, RoutedEventArgs e)
        {
            // If we haven't started dragging, don't start a drag.
            beginDrag = false;
            if (core.dragging)
            {
                // Finished a drag.
                core.dragging = false;
                core.doString("processEvent(" + dropTargets.Peek().myID + ", \"OnDragFinish\", " + dropTargets.Peek().myID + ");");
            }
            core.doString("processEvent(" + myID.ToString() + ", \"OnMouseUp\");");
        }

        void onKeyDown(object sender, RoutedEventArgs e)
        {
            core.doString("processEvent(" + myID.ToString() + ", \"OnKeyDown\");");
        }

        void onKeyPress(object sender, RoutedEventArgs e)
        {
            core.doString("processEvent(" + myID.ToString() + ", \"OnKeyPress\");");
        }
        
        void onKeyUp(object sender, RoutedEventArgs e)
        {
            core.doString("processEvent(" + myID.ToString() + ", \"OnKeyUp\");");
        }

        void onMouseMove(object sender, RoutedEventArgs e)
        {
            // If we are ready to begin dragging and the dragBox does not contain the mouse, then we start dragging.
            if (beginDrag == true && !dragBox.Contains(new Point(System.Windows.Forms.Control.MousePosition.X, System.Windows.Forms.Control.MousePosition.Y)))
            {
                beginDrag = false;
                core.dragging = true;
                core.doString("processEvent(" + myID.ToString() + ", \"OnDragStart\", " + dropTargets.Peek().myID + ");");
            }
            core.doString("processEvent(" + myID.ToString() + ", \"OnMouseMove\", " + System.Windows.Forms.Control.MousePosition.X + ", " + System.Windows.Forms.Control.MousePosition.Y + ");");
        }

        private static bool JustDoAllGeezWhyIsThisNeeded(Pane StupidNeededPaneToo)
        {
            return true;
        }

        // Closes this pane
        public void close()
        {
            // send an event so app can close itself properly.
            //core.doString("processEvent(" + myID.ToString() + ", \"OnClose\");");
            
            this.hideAll();
            Parent = null;
            Children.RemoveAll(new Predicate<Pane>(JustDoAllGeezWhyIsThisNeeded));
        }

        // Since C# has access to information like SystemInformation.DragSize, we perform drag events from C#.

        //void checkStart

        public Pane(Core newCore)
        {
            core = newCore;
            myCanvas = new Canvas();
            myCanvas.Background = Brushes.Transparent;
            myCanvas.AddHandler(Canvas.MouseUpEvent, new RoutedEventHandler(onClick));
            myCanvas.AddHandler(Canvas.MouseEnterEvent, new RoutedEventHandler(onMouseEnter));
            myCanvas.AddHandler(Canvas.MouseLeaveEvent, new RoutedEventHandler(onMouseLeave));
            myCanvas.AddHandler(Canvas.MouseDownEvent, new RoutedEventHandler(onMouseDown));
            myCanvas.AddHandler(Canvas.MouseUpEvent, new RoutedEventHandler(onMouseUp));
            myCanvas.AddHandler(Canvas.KeyDownEvent, new RoutedEventHandler(onKeyDown));
            myCanvas.AddHandler(Canvas.KeyUpEvent, new RoutedEventHandler(onKeyUp));
            myCanvas.AddHandler(Canvas.MouseMoveEvent, new RoutedEventHandler(onMouseMove));

            myChildren = new ArrayList<Pane>();
        }

        public Canvas getCanvas()
        {
            return myCanvas;
        }

        public void setBackground(Brush background)
        {
            //Console.WriteLine("Background set attempted.");
            //myCanvas.Background = Brushes.Aqua;
            myCanvas.Background = background;
            //myPanel.Background.
        }

        // Width and height are width and height of border, not pane.
        public void setBorderedBackground(Uri image, int width, int height)
        {
            myDraw = new BorderDraw(image, width, height, (int)myCanvas.Width, (int)myCanvas.Height);
            myCanvas.Background = myDraw.getAsBrush();
        }

        public void addChild(Pane p)
        {
            ////Parentable parent = p.Parent;
            UIElement pUI = unwrap(p);

            //Console.WriteLine(p.Parent.GetType());

            // If my parent is a pane, remove me from the canvas.
            //if (p.Parent is Pane && ((Pane)p.Parent).getCanvas().Children.IndexOf(pUI) != -1)
            //{
            //    ((Pane)p.Parent).getCanvas().Children.Remove(pUI);
            //    ((Pane)p.Parent).removeChild(p);
            //}

            //if (p.Parent is Region && ((Region)p.Parent).getPane().getCanvas().Children.IndexOf(pUI) != -1)
            //{
            //    ((Region)p.Parent).getPane().getCanvas().Children.Remove(pUI);
            //    ((Region)p.Parent).getPane().removeChild(p);
            //}

            //if (myCanvas.Children.IndexOf(pUI) != -1)
            //{
            //    myCanvas.Children.Remove(pUI);
            //}

            //try
            //{
            //    if (p.Parent != null)
            //    {
            //        p.Parent.removeChild(p);
            //    }
            //    myCanvas.Children.Add(pUI);
            //    Children.Add(p);
            //}

            //catch (Exception e)
            //{
            //    Console.WriteLine("Adding child to parent failed.");
            //    Console.WriteLine("p is of type" + p.GetType().ToString());
            //    Console.WriteLine("pUI is of type" + pUI.GetType().ToString());
            //    throw e;
            //}

            p.Parent = this;

            pUI.Visibility = System.Windows.Visibility.Visible;
        }

        // Remove child from current Pane
        public void removeChild(Pane child)
        {
            //Console.WriteLine("Attempting to remove " + child.ToString() + " from " + child.Parent.ToString() + ".");

            //try
            //{
            //    UIElement myChild = unwrap(child);
            //    myChild.Visibility = System.Windows.Visibility.Hidden;
            //    Pane parent = child.Parent;

            //    myCanvas.Children.Remove(myChild);
            //    myCanvas.UpdateLayout();

            //    Children.Remove(child);
            //}
            //catch (Exception e)
            //{
            //    throw e;
            //}

            child.Parent = null;

            //Console.WriteLine("Attempted to remove");
        }

        // Helper method to unwrap objects I've wrapped.
        private UIElement unwrap(object p)
        {
            //if (p is Text)
            //{
            //    return ((Text)(p)).getLabel();
            //}
            //else if (p is Pane)
            if (p is Pane)
            {
                return ((Pane)(p)).getCanvas();
            }
            else if ((p) is UIElement)
            {
                return (UIElement)(p);
            }
            else
            {
                throw new Exception("Inappropriate type. Got " + p.GetType().ToString() + " instead.");
            }
        }

        //public void setID(int id)
        //{
        //    myID = id;
        //}

        internal void SetValue(DependencyProperty dependencyProperty, object value)
        {
            myCanvas.SetValue(dependencyProperty, value);

            // update height and width, just in case.
            this.height = (int)myCanvas.Height;
            this.width = (int)myCanvas.Width;
        }

    }
}
