﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;

namespace AddonsForLife
{
    // Represents a window.
    class Frame
    {
        private Window frameWindow;
        private Panel childContainer;
        private int myID;

        Core core;

        void onClick(object sender, RoutedEventArgs e)
        {
            Console.WriteLine(sender.ToString());
            Console.WriteLine(e.ToString());
            Console.WriteLine("This: " + this.ToString());
            core.doString("processEvent(" + myID.ToString() + ", \"OnClick\");");
        }

        public Frame(Window window, Core newCore)
        {
            frameWindow = window;
            childContainer = new Grid();
            frameWindow.Content = childContainer;
            ((Grid)childContainer).ShowGridLines = true;
            //frameWindow.Background = Brushes.Transparent;
            childContainer.Background = Brushes.Transparent;
            //((Grid)childContainer).Width = 100;
            //((Grid)childContainer).Height = 100;

            childContainer.AddHandler(Panel.MouseUpEvent, new RoutedEventHandler(onClick));
            core = newCore;
            return;
        }

        public void setGridPosition(object child, int column, int row)
        {
            if (frameWindow.Content is Grid)
            {
                Grid myGrid = (Grid)(frameWindow.Content);
                if (myGrid.ColumnDefinitions.Count < column+1)
                {
                    for (int x = myGrid.ColumnDefinitions.Count-1; x < column; x++)
                    {
                        myGrid.ColumnDefinitions.Add(new ColumnDefinition());
                    }
                }

                if (myGrid.RowDefinitions.Count < row+1)
                {
                    for (int x = myGrid.RowDefinitions.Count-1; x < row; x++)
                    {
                        myGrid.RowDefinitions.Add(new RowDefinition());
                    }
                }

                Grid.SetColumn(unwrap(child),column);
                Grid.SetRow(unwrap(child), row);
            }
        }

        //public Window getWindow()
        //{
        //    return frameWindow;
        //}


        public void addChild(object p)
        {
            childContainer.Children.Add(unwrap(p));
        }

        // Helper method to unwrap objects I've wrapped.
        private UIElement unwrap(object p)
        {
            if (p is Text)
            {
                return ((Text)(p)).getLabel();
            } else if (p is Pane)
            {
                return ((Pane)(p)).getPanel();
            } else if ((p) is UIElement)
            {
                return (UIElement)(p);
            } else
            {
                throw new Exception("Inappropriate type. Got " + p.GetType().ToString() + " instead.");
            }
        }
        public void setID(int id)
        {
            myID = id;
        }
    }

}
