﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Collections;
using System.Windows.Controls;
using LuaInterface;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace AddonsForLife
{
    // Since "App" can't access the window, this is our core class instead.
    class Core
    {
        // Lua core
        private Lua myLua = new Lua();

        Window1 mainWindow = null;

        string textBuffer = "";

        // Initialize widget types.
        private Widgets widgets = null;

        // Set to false to stop running new lines of code.
        Boolean running = true;

        // If this is true, a drag and drop operation is taking place.
        public Boolean dragging = false;

        public string rootFolder = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments) + @"\AddonsForLife\";

        public void printString(String text)
        {
            textBuffer = textBuffer + "\r\n" + text;
            mainWindow.textBlock1.Text = textBuffer;
            Console.Write(text);
        }

        public void forceQuit()
        {
            Console.WriteLine("Lua shutting down.");
            running = false;
            widgets.stopAll();
            try
            {
                mainWindow.Close();
                Application.Current.Shutdown(1);
                myLua.Close();
            }
            finally
            {
                // This normally throws errors, but we don't care about them.
            }
            Console.WriteLine("Lua shut this down.");
            //throw new Exception("Lua shut this down.");
        }

        // To be called when Lua encounters an exception from C#.
        public void CException(Object e)
        {
            Console.WriteLine("==C# Error handled by Lua!==");
            if (e is LuaScriptException)
            {
                LuaScriptException ex = (LuaScriptException)e;
                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + " raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);

                // Extra unwinding
                if (ex.InnerException != null)
                {
                    Console.WriteLine("==Extra stack trace==");
                    Console.WriteLine(ex.InnerException.ToString());
                    Console.WriteLine(ex.InnerException.Message);
                    Console.WriteLine(ex.InnerException.Source + " raised the following type of exception: " + ex.InnerException.GetType().ToString());
                    Console.WriteLine(ex.InnerException.StackTrace);
                }
            }
            else
            {
                Console.WriteLine("Unknown exception of type " + e.GetType().ToString());
                throw new Exception(e.GetType().ToString());
            }

            forceQuit();
        }

        void onBadException(object sender, EventArgs e)
        {
            throw new Exception("Very bad exception.");
        }

        public Core(Window1 newWindow)
        {
            Console.WriteLine("Loading core");
            mainWindow = newWindow;
            
            doString("_CSHARP={};");
            // Register printer so Lua can print.
            myLua.RegisterFunction("_CSHARP.CPrint", this, this.GetType().GetMethod("printString"));
            myLua.RegisterFunction("_CSHARP._FORCEQUIT", this, this.GetType().GetMethod("forceQuit"));
            myLua.RegisterFunction("_CSHARP._CERROR", this, this.GetType().GetMethod("CException"));

            myLua.HookException += onBadException;
            myLua.DebugHook += onBadException;

            // Load Lua error handling file.
            try
            {
                doString("rootFolder=\"" + addSlashes(rootFolder) + "\"");
                Console.WriteLine("Loading error file (C#).");
                myLua.DoFile(addSlashes(rootFolder + "error.lua"));
                Console.WriteLine("Done loading error file (C#).");
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error file failed to load.");
                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + " raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);
                throw ex;
            }

            try
            {
                widgets = new Widgets(myLua, this);
            }
            catch (Exception e)
            {
                Console.WriteLine("Error loading widgets.");
                Console.WriteLine(e.Message);
                Console.WriteLine(e.StackTrace);
                throw e;
            }

            Console.WriteLine("Core loaded.");
        }

        public void launchApp(String name, bool sandboxed)
        {
            if (running == false)
            {
                throw new Exception("Unable to run more code.");
            }

            Console.WriteLine("Launching application " + name + "\n");
            string doString = "";
            try
            {
                //object[] returns = myLua.DoFile(name);

                //LuaFunction luaFunc = myLua.LoadFile(name);
                //myLua.Push(luaFunc);
                //myLua.DoString("pcall(")
                //Console.Write(luaFunc.Call());
                //Console.WriteLine("LAUNCH\r\nerr = dofile(\"" + name + "\"); if err ~= nil then print(\"==============\"); luaError(err) end;");

                // Yeah, DoString likes to escape those slashes. Grr.
                if (sandboxed)
                {
                    myLua.DoString("doFile(\"" + addSlashes(rootFolder + name + ".lua") + "\", \"" + name + "\", true)");
                }
                else
                {
                    myLua.DoString("doFile(\"" + addSlashes(rootFolder + name + ".lua") + "\", \"" + name + "\", false)");
                }


                //if (returns != null)
                //{
                //    printString(returns.Length.ToString());
                //    for (int x = 0; x < returns.Length; x++)
                //    {
                //        printString(returns[x].GetType().ToString());
                //    }
                //}
            }
            catch (System.Runtime.InteropServices.SEHException e)
            {
                Console.WriteLine("BAD EXCEPTION NO BISCUIT!");
                Console.WriteLine(e.StackTrace);
            }
            catch (Exception e)
            {

                //LuaDebug debug;
                //myLua.GetStack(1, debug);
                //myLua.DoString("luaError();");

                //myLua.DoString("error();");
                Console.WriteLine("Error when trying to run: " + name);
                Console.WriteLine("Error in code: " + doString);
                //myLua.DoString("info=debug.getinfo(1, \"Sl\"); print(info.source); print(debug.traceback())");

                Console.WriteLine("--BEGIN----------------------------------------------------------------------------------");
                Console.WriteLine(e.ToString());
                Console.WriteLine("-MESSAGE---------------------------------------------------------------------------------");
                Console.WriteLine(e.Message);
                Console.WriteLine("-ERROR-----------------------------------------------------------------------------------");
                Console.WriteLine(e.Source + " raised the following type of exception: " + e.GetType().ToString());
                Console.WriteLine("-STACK TRACE-----------------------------------------------------------------------------");
                Console.WriteLine(e.StackTrace);

                if (e.InnerException != null)
                {
                    Console.WriteLine("-EXTRA STACK TRACE-----------------------------------------------------------------------");
                    Console.WriteLine(e.InnerException.ToString());
                    Console.WriteLine(e.InnerException.Message);
                    Console.WriteLine(e.InnerException.Source + " raised the following type of exception: " + e.InnerException.GetType().ToString());
                    Console.WriteLine(e.InnerException.StackTrace);
                }

                Console.WriteLine("--END------------------------------------------------------------------------------------");

                // Rethrow it to get complete stack trace >.<
                throw e;
            }



            //Console.WriteLine(myLua.GetString("printMe"));
            Console.WriteLine(name + " launched.");
        }

        public void doString(String stuff)
        {
            //String call = "doString(" + stuff + ")";

            if(running == false)
            {
                throw new Exception("Unable to run more code.");
            }

            try
            {
                //Console.WriteLine("CALL\r\n" + call);
                //myLua.DoString("doString(\"" + stuff + "\");");
                myLua.DoString(stuff);
            }
            catch (Exception ex)
            {
                Console.WriteLine("The following code failed:\n" + stuff);
                //myLua.DoString("info=debug.getinfo(1, \"Sl\"); print(info.source); print(debug.traceback())");
                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + " raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);
                
                // Rethrow it to get complete stack trace >.<
                throw ex;
            }
        }

        public string addSlashes(string text)
        {
            return text.Replace("\\", "\\\\");
        }

        // Throws an error in Lua, to enable good debugging.
        //public void luaError(String message)
        //{
        //    Console.WriteLine("ERROR: " + message);
        //    myLua.DoString("error(\"" + message + "\");");
        //}

    }
}
