﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Collections;
using System.Windows.Controls;
using LuaInterface;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace AddonsForLife
{
    // Since "App" can't access the window, this is our core class instead.
    class Core
    {
        // Lua core
        private Lua myLua = new Lua();

        Window1 mainWindow = null;

        string textBuffer = "";

        // Initialize widget types.
        private Widgets widgets = null;

        // Set to false to stop running new lines of code.
        Boolean running = true;

        public void printString(String text)
        {
            textBuffer = textBuffer + "\r\n" + text;
            mainWindow.textBlock1.Text = textBuffer;
            Console.WriteLine(text);
        }

        public void forceQuit()
        {
            running = false;
            widgets.stopAll();
            mainWindow.Close();
            Application.Current.Shutdown(1);
            myLua.Close();
            throw new Exception("Lua shut this down.");
        }

        // To be called when Lua encounters an exception from C#.
        public void CException(Object e)
        {
            if (e is LuaScriptException)
            {
                LuaScriptException ex = (LuaScriptException)e;
                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + " raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);
            }
            else
            {
                Console.WriteLine("Unknown exception of type " + e.GetType().ToString());
                throw new Exception(e.GetType().ToString());
            }

            forceQuit();
        }

        public Core(Window1 newWindow)
        {
            Console.WriteLine("Loading core");
            mainWindow = newWindow;
            
            doString("_CSHARP={};");
            // Register printer so Lua can print.
            myLua.RegisterFunction("_CSHARP.CPrint", this, this.GetType().GetMethod("printString"));
            myLua.RegisterFunction("_CSHARP._FORCEQUIT", this, this.GetType().GetMethod("forceQuit"));
            myLua.RegisterFunction("_CSHARP._CERROR", this, this.GetType().GetMethod("CException"));

            // Load Lua error handling file.
            try
            {
                Console.WriteLine("Loading error file (C#).");
                myLua.DoFile("D:\\Documents\\Visual Studio 2008\\Projects\\AddonsForLife\\error.lua");
                Console.WriteLine("Done loading error file (C#).");
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error file failed to load.");
                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + " raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);
            }

            widgets = new Widgets(myLua, this);

            Console.WriteLine("Core loaded.");

        }

        public void launchApp(String name)
        {
            if (running == false)
            {
                throw new Exception("Unable to run more code.");
            }

            Console.WriteLine("Launching application " + name);
            string doString = "";
            try
            {
                //object[] returns = myLua.DoFile(name);

                //LuaFunction luaFunc = myLua.LoadFile(name);
                //myLua.Push(luaFunc);
                //myLua.DoString("pcall(")
                //Console.Write(luaFunc.Call());
                //Console.WriteLine("LAUNCH\r\nerr = dofile(\"" + name + "\"); if err ~= nil then print(\"==============\"); luaError(err) end;");
                
                 myLua.DoString("doFile(\"" + name + "\")");


                //if (returns != null)
                //{
                //    printString(returns.Length.ToString());
                //    for (int x = 0; x < returns.Length; x++)
                //    {
                //        printString(returns[x].GetType().ToString());
                //    }
                //}
            }
            catch (Exception e)
            {

                //LuaDebug debug;
                //myLua.GetStack(1, debug);
                //myLua.DoString("luaError();");

                //myLua.DoString("error();");
                Console.WriteLine("Error in code: " + doString);
                //myLua.DoString("info=debug.getinfo(1, \"Sl\"); print(info.source); print(debug.traceback())");

                Console.WriteLine("--BEGIN----------------------------------------------------------------------------------");
                Console.WriteLine(e.ToString());
                Console.WriteLine("-----------------------------------------------------------------------------------------");
                Console.WriteLine(e.Message);
                Console.WriteLine("-----------------------------------------------------------------------------------------");
                Console.WriteLine(e.Source + "raised the following type of exception: " + e.GetType().ToString());
                Console.WriteLine("-STACK TRACE-----------------------------------------------------------------------------");
                Console.WriteLine(e.StackTrace);
                Console.WriteLine("--END------------------------------------------------------------------------------------");

                // Rethrow it to get complete stack trace >.<
                throw e;
            }



            //Console.WriteLine(myLua.GetString("printMe"));
            Console.WriteLine("Application launched");
        }

        public void doString(String stuff)
        {
            //String call = "doString(" + stuff + ")";

            if(running == false)
            {
                throw new Exception("Unable to run more code.");
            }

            try
            {
                //Console.WriteLine("CALL\r\n" + call);

                myLua.DoString(stuff);
            }
            catch (Exception ex)
            {
                Console.WriteLine("The following code failed:\n" + stuff);
                //myLua.DoString("info=debug.getinfo(1, \"Sl\"); print(info.source); print(debug.traceback())");
                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + " raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);
                
                // Rethrow it to get complete stack trace >.<
                throw ex;
            }
        }

        // Throws an error in Lua, to enable good debugging.
        //public void luaError(String message)
        //{
        //    Console.WriteLine("ERROR: " + message);
        //    myLua.DoString("error(\"" + message + "\");");
        //}

    }
}
