﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Collections;
using System.Windows.Controls;
using LuaInterface;

namespace AddonsForLife
{
    // Since "App" can't access the window, this is our core class instead.
    class Core
    {
        // Lua core
        private Lua myLua = new Lua();

        Window1 mainWindow = null;
        string textBuffer = "";

        // Initialize widget types.
        private Widgets widgets = null;

        public Core(Window1 newWindow)
        {
            Console.WriteLine("Loading core");
            mainWindow = newWindow;

            widgets = new Widgets(myLua, this);

            Console.WriteLine("Core loaded.");

        }

        public void launchApp(String name)
        {
            Console.WriteLine("Launching application " + name);
            string doString = "";
            try
            {
                //object[] returns = myLua.DoFile(name);

                //LuaFunction luaFunc = myLua.LoadFile(name);
                //myLua.Push(luaFunc);
                //myLua.DoString("pcall(")
                //Console.Write(luaFunc.Call());
                //Console.WriteLine("LAUNCH\r\nerr = dofile(\"" + name + "\"); if err ~= nil then print(\"==============\"); luaError(err) end;");
                doString = "file,code = loadfile(\"" + name + "\"); if file==nil then print(\"ERROR: \"); error(code) else err,code = pcall(file); if (err == false) then if type(code)~=\"userdata\" then print(\"ERROR: \"..type(code)); luaError(code); end; end; end;";
                myLua.DoString(doString);


                //if (returns != null)
                //{
                //    printString(returns.Length.ToString());
                //    for (int x = 0; x < returns.Length; x++)
                //    {
                //        printString(returns[x].GetType().ToString());
                //    }
                //}
            }
            catch (Exception e)
            {

                //LuaDebug debug;
                //myLua.GetStack(1, debug);
                //myLua.DoString("luaError();");

                //myLua.DoString("error();");
                Console.WriteLine("ERROR(" + doString + ")");
                myLua.DoString("info=debug.getinfo(1, \"Sl\"); print(info.source); print(debug.traceback())");

                Console.WriteLine("--BEGIN----------------------------------------------------------------------------------");
                Console.WriteLine(e.ToString());
                Console.WriteLine("-----------------------------------------------------------------------------------------");
                Console.WriteLine(e.Message);
                Console.WriteLine("-----------------------------------------------------------------------------------------");
                Console.WriteLine(e.Source + "raised the following type of exception: " + e.GetType().ToString());
                Console.WriteLine("-----------------------------------------------------------------------------------------");
                Console.WriteLine(e.StackTrace);
                Console.WriteLine("--END------------------------------------------------------------------------------------");

            }



            //Console.WriteLine(myLua.GetString("printMe"));
            Console.WriteLine("Application launched");
        }

        public void printString(String text)
        {
            textBuffer = textBuffer + "\r\n" + text;
            mainWindow.textBlock1.Text = textBuffer;
            Console.WriteLine(text);
        }

        public void doString(String stuff)
        {
            String call = "err = pcall(function() \n\r" + stuff + "\n\rend); if (err ~= nil) then print(err); luaError(err); error(err); end;";
            //String call = "print(\"=============!\");";

            try
            {
                //Console.WriteLine("CALL\r\n" + call);
                object[] result = myLua.DoString(stuff);
                if (result != null)
                {
                    // errors
                    Console.WriteLine(myLua.DoString("error()"));
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                Console.WriteLine(ex.Message);
                Console.WriteLine(ex.Source + "raised the following type of exception: " + ex.GetType().ToString());
                Console.WriteLine(ex.StackTrace);
            }
        }

        // Throws an error in Lua, to enable good debugging.
        //public void luaError(String message)
        //{
        //    Console.WriteLine("ERROR: " + message);
        //    myLua.DoString("error(\"" + message + "\");");
        //}

    }
}
