﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AddonsForLife
{
    class BorderDraw
    {
        public int borderWidth { get; set; }
        public int borderHeight { get; set; }
        private DrawingGroup borderGroup;


        public BorderDraw(Uri url, int borderWidth, int borderHeight)
        {
            borderGroup = new DrawingGroup();

            BitmapImage source = new BitmapImage(url);
            int imageWidth = source.PixelWidth;
            int imageHeight = source.PixelHeight;

            this.borderWidth = borderWidth;
            this.borderHeight = borderHeight;
            
            // t=top, l=left, b=bottom, r=right
            ImageDrawing tlDraw = new ImageDrawing(source, new Rect(0, 0, borderWidth, borderHeight));
            
            ImageDrawing tDraw = new ImageDrawing(source, new Rect(borderWidth, 0, imageWidth-borderWidth, borderHeight));
            
            borderGroup.Children.Add(tlDraw);
            Rectangle tlRect = new Rectangle();
            tlRect.Height = borderHeight;
            tlRect.Width = borderWidth;
            tlRect.t

            borderGroup.ClipGeometry = tlRect;
            

            borderGroup.Children.Add(tDraw);
        }

        public DrawingGroup getDrawing()
        {
            return borderGroup;
        }

        public Brush getAsBrush()
        {
            DrawingBrush newBrush = new DrawingBrush();
            newBrush.Drawing = borderGroup;
            return newBrush;
        }
    }
}
