﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Media;
using System.Windows;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Controls;
using System.Windows.Media.Effects;

namespace AddonsForLife
{
    class BorderDraw
    {
        public double brushWidth { get; set; }
        public double brushHeight { get; set; }
        public double borderWidth { get; set; }
        public double borderHeight { get; set; }
        public Uri url { get; set; }

        private DrawingGroup borderGroup;

        public BorderDraw(Uri url, double borderWidth, double borderHeight, double brushWidth, double brushHeight)
        {
            this.url = url;
            this.borderWidth = borderWidth;
            this.borderHeight = borderHeight;
            this.brushWidth = brushWidth;
            this.brushHeight = brushHeight;

            update();
            
        }

        public DrawingGroup getDrawing()
        {
            return borderGroup;
        }

        public Brush getAsBrush()
        {
            DrawingBrush newBrush = new DrawingBrush();
            newBrush.Drawing = borderGroup;
            return newBrush;
        }

        // Updates the brush
        public void update()
        {
            borderGroup = new DrawingGroup();

            BitmapImage source = new BitmapImage(url);
            double imageWidth = source.PixelWidth;
            double imageHeight = source.PixelHeight;

            this.borderWidth = borderWidth;
            this.borderHeight = borderHeight;

            double brushNormW = (double)imageWidth / (double)brushWidth;
            double brushNormH = (double)imageHeight / (double)brushHeight;

            //Console.WriteLine("");
            //Console.WriteLine("imageWidth: " + imageWidth);
            //Console.WriteLine("borderWidth: " + borderWidth);
            //Console.WriteLine("brushWidth: " + brushWidth);
            //Console.WriteLine("brushNormW: " + brushNormW);

            ImageDrawing draw = new ImageDrawing(source, new Rect(0, 0, imageWidth, imageHeight));

            // t=top, l=left, b=bottom, r=right
            //ImageBrush tlDraw = new ImageBrush(source);
            //    new ImageDrawing(source, new Rect(0, 0, borderWidth, borderHeight));
            //tl.Background = tlDraw;

            // *..
            // ...
            // ...
            DrawingGroup tl = new DrawingGroup();
            tl.Children.Add(draw);
            RectangleGeometry tlClip = new RectangleGeometry(new Rect(0, 0, borderWidth, borderHeight));
            tl.ClipGeometry = tlClip;
            borderGroup.Children.Add(tl);

            // .*.
            // ...
            // ...
            DrawingGroup t = new DrawingGroup();
            t.Children.Add(draw);
            RectangleGeometry tClip = new RectangleGeometry(new Rect(borderWidth, 0, imageWidth - 2.0 * borderWidth, borderHeight));
            t.ClipGeometry = tClip;
            TransformGroup tGTrans = new TransformGroup();
            TranslateTransform tTTrans = new TranslateTransform(borderWidth - (borderWidth * (brushWidth - 2.0 * borderWidth)) / (imageWidth - 2.0 * borderWidth), 0);
            ScaleTransform tSTrans = new ScaleTransform((brushWidth - 2.0 * borderWidth) / (imageWidth - 2.0 * borderWidth), 1.0);
            tGTrans.Children.Add(tSTrans);
            tGTrans.Children.Add(tTTrans);
            t.Transform = tGTrans;
            borderGroup.Children.Add(t);

            // ..*
            // ...
            // ...
            DrawingGroup tr = new DrawingGroup();
            tr.Children.Add(draw);
            RectangleGeometry trClip = new RectangleGeometry(new Rect(imageWidth - borderWidth, 0, borderWidth, borderHeight));
            tr.Transform = new TranslateTransform(brushWidth - imageWidth, 0);
            tr.ClipGeometry = trClip;
            borderGroup.Children.Add(tr);


            // ...
            // *..
            // ...
            DrawingGroup l = new DrawingGroup();
            l.Children.Add(draw);
            RectangleGeometry lClip = new RectangleGeometry(new Rect(0, borderHeight, borderWidth, imageHeight - 2.0 * borderHeight));
            l.ClipGeometry = lClip;
            TransformGroup lGTrans = new TransformGroup();
            TranslateTransform lTTrans = new TranslateTransform(0, borderHeight - (borderHeight * (brushHeight - 2.0 * borderHeight)) / (imageHeight - 2.0 * borderHeight));
            ScaleTransform lSTrans = new ScaleTransform(1.0, (brushHeight - 2.0 * borderHeight) / (imageHeight - 2.0 * borderHeight));
            lGTrans.Children.Add(lSTrans);
            lGTrans.Children.Add(lTTrans);
            l.Transform = lGTrans;
            borderGroup.Children.Add(l);

            // ...
            // .*.
            // ...
            DrawingGroup c = new DrawingGroup();

            c.Children.Add(draw);
            RectangleGeometry cClip = new RectangleGeometry(new Rect(borderWidth, borderHeight, imageWidth - 2.0 * borderWidth, imageHeight - 2.0 * borderHeight));
            c.ClipGeometry = cClip;
            TransformGroup cGTrans = new TransformGroup();
            TranslateTransform cTTrans = new TranslateTransform(borderWidth - (borderWidth * (brushWidth - 2.0 * borderWidth)) / (imageWidth - 2.0 * borderWidth), borderHeight - (borderHeight * (brushHeight - 2.0 * borderHeight)) / (imageHeight - 2.0 * borderHeight));
            ScaleTransform cSTrans = new ScaleTransform((brushWidth - 2.0 * borderWidth) / (imageWidth - 2.0 * borderWidth), (brushHeight - 2.0 * borderHeight) / (imageHeight - 2.0 * borderHeight));
            cGTrans.Children.Add(cSTrans);
            cGTrans.Children.Add(cTTrans);
            c.Transform = cGTrans;
            borderGroup.Children.Add(c);

            // ...
            // ..*
            // ...
            DrawingGroup r = new DrawingGroup();
            r.Children.Add(draw);
            RectangleGeometry rClip = new RectangleGeometry(new Rect(imageWidth - borderWidth, borderHeight, borderWidth, imageHeight - 2.0 * borderHeight));
            r.ClipGeometry = rClip;
            TransformGroup rGTrans = new TransformGroup();
            TranslateTransform rTTrans = new TranslateTransform(brushWidth - imageWidth, borderHeight - (borderHeight * (brushHeight - 2.0 * borderHeight)) / (imageHeight - 2.0 * borderHeight));
            ScaleTransform rSTrans = new ScaleTransform(1.0, (brushHeight - 2.0 * borderHeight) / (imageHeight - 2.0 * borderHeight));
            rGTrans.Children.Add(rSTrans);
            rGTrans.Children.Add(rTTrans);
            r.Transform = rGTrans;
            borderGroup.Children.Add(r);

            // ...
            // ...
            // *..
            DrawingGroup bl = new DrawingGroup();

            bl.Children.Add(draw);
            RectangleGeometry blClip = new RectangleGeometry(new Rect(0, imageHeight - borderHeight, borderWidth, borderHeight));
            bl.ClipGeometry = blClip;
            bl.Transform = new TranslateTransform(0, brushHeight - imageHeight);
            borderGroup.Children.Add(bl);

            // ...
            // ...
            // .*.
            DrawingGroup b = new DrawingGroup();

            b.Children.Add(draw);
            RectangleGeometry bClip = new RectangleGeometry(new Rect(borderWidth, imageHeight - borderHeight, imageWidth - 2.0 * borderWidth, borderHeight));
            b.ClipGeometry = bClip;
            TransformGroup bGTrans = new TransformGroup();
            TranslateTransform bTTrans = new TranslateTransform(borderWidth - (borderWidth * (brushWidth - 2.0 * borderWidth)) / (imageWidth - 2.0 * borderWidth), brushHeight - imageHeight);
            ScaleTransform bSTrans = new ScaleTransform((brushWidth - 2.0 * borderWidth) / (imageWidth - 2.0 * borderWidth), 1.0);
            bGTrans.Children.Add(bSTrans);
            bGTrans.Children.Add(bTTrans);
            b.Transform = bGTrans;
            borderGroup.Children.Add(b);

            // ...
            // ...
            // ..*
            DrawingGroup br = new DrawingGroup();

            br.Children.Add(draw);
            RectangleGeometry brClip = new RectangleGeometry(new Rect(imageWidth - borderWidth, imageHeight - borderHeight, borderWidth, borderHeight));
            br.ClipGeometry = brClip;
            br.Transform = new TranslateTransform(brushWidth - imageWidth, brushHeight - imageHeight);
            borderGroup.Children.Add(br);

            //borderGroup.ClipGeometry = new RectangleGeometry(new Rect(0, 0, brushWidth, brushHeight));
        }
    }
}
